/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.ability;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.ability.GenericShapeAbility;
import dev.tocraft.walkers.ability.ShapeAbility;
import dev.tocraft.walkers.ability.impl.generic.ClearEffectsAbility;
import dev.tocraft.walkers.ability.impl.generic.ExplosionAbility;
import dev.tocraft.walkers.ability.impl.generic.GetItemAbility;
import dev.tocraft.walkers.ability.impl.generic.JumpAbility;
import dev.tocraft.walkers.ability.impl.generic.RandomTeleportationAbility;
import dev.tocraft.walkers.ability.impl.generic.SaturateAbility;
import dev.tocraft.walkers.ability.impl.generic.ShootDragonFireball;
import dev.tocraft.walkers.ability.impl.generic.ShootFireballAbility;
import dev.tocraft.walkers.ability.impl.generic.ShootSnowballAbility;
import dev.tocraft.walkers.ability.impl.generic.TeleportationAbility;
import dev.tocraft.walkers.ability.impl.generic.ThrowPotionsAbility;
import dev.tocraft.walkers.ability.impl.specific.AngerAbility;
import dev.tocraft.walkers.ability.impl.specific.BreezeAbility;
import dev.tocraft.walkers.ability.impl.specific.ChickenAbility;
import dev.tocraft.walkers.ability.impl.specific.EvokerAbility;
import dev.tocraft.walkers.ability.impl.specific.GoatAbility;
import dev.tocraft.walkers.ability.impl.specific.GuardianAbility;
import dev.tocraft.walkers.ability.impl.specific.LlamaAbility;
import dev.tocraft.walkers.ability.impl.specific.PufferfishAbility;
import dev.tocraft.walkers.ability.impl.specific.RabbitAbility;
import dev.tocraft.walkers.ability.impl.specific.RaidAbility;
import dev.tocraft.walkers.ability.impl.specific.SheepAbility;
import dev.tocraft.walkers.ability.impl.specific.ShulkerAbility;
import dev.tocraft.walkers.ability.impl.specific.SnifferAbility;
import dev.tocraft.walkers.ability.impl.specific.TurtleAbility;
import dev.tocraft.walkers.ability.impl.specific.WardenAbility;
import dev.tocraft.walkers.ability.impl.specific.WitherAbility;
import dev.tocraft.walkers.integrations.Integrations;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_10730;
import net.minecraft.class_10823;
import net.minecraft.class_10824;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1438;
import net.minecraft.class_1454;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1481;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1564;
import net.minecraft.class_1571;
import net.minecraft.class_1577;
import net.minecraft.class_1606;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1640;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3483;
import net.minecraft.class_4466;
import net.minecraft.class_5354;
import net.minecraft.class_6053;
import net.minecraft.class_6862;
import net.minecraft.class_7260;
import net.minecraft.class_8153;
import net.minecraft.class_8949;
import net.minecraft.class_9254;
import net.minecraft.class_9334;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbilityRegistry {
    private static final Map<Predicate<class_1309>, ShapeAbility<?>> specificAbilities = Collections.synchronizedMap(new LinkedHashMap());
    private static final Map<Predicate<class_1309>, GenericShapeAbility<?>> genericAbilities = Collections.synchronizedMap(new LinkedHashMap());
    private static final Map<class_2960, MapCodec<? extends GenericShapeAbility<?>>> abilityCodecById = new HashMap();
    private static final Map<MapCodec<? extends GenericShapeAbility<?>>, class_2960> abilityIdByCodec = new IdentityHashMap();

    @ApiStatus.Internal
    public static void initialize() {
        AbilityRegistry.registerCodec(ShootFireballAbility.ID, ShootFireballAbility.CODEC);
        AbilityRegistry.registerCodec(ClearEffectsAbility.ID, ClearEffectsAbility.CODEC);
        AbilityRegistry.registerCodec(ExplosionAbility.ID, ExplosionAbility.CODEC);
        AbilityRegistry.registerCodec(ShootDragonFireball.ID, ShootDragonFireball.CODEC);
        AbilityRegistry.registerCodec(TeleportationAbility.ID, TeleportationAbility.CODEC);
        AbilityRegistry.registerCodec(RandomTeleportationAbility.ID, RandomTeleportationAbility.CODEC);
        AbilityRegistry.registerCodec(JumpAbility.ID, JumpAbility.CODEC);
        AbilityRegistry.registerCodec(ThrowPotionsAbility.ID, ThrowPotionsAbility.CODEC);
        AbilityRegistry.registerCodec(SaturateAbility.ID, SaturateAbility.CODEC);
        AbilityRegistry.registerCodec(ShootSnowballAbility.ID, ShootSnowballAbility.CODEC);
        AbilityRegistry.registerCodec(GetItemAbility.ID, GetItemAbility.CODEC);
    }

    @ApiStatus.Internal
    public static void registerDefault() {
        AbilityRegistry.registerByPredicate(livingEntity -> livingEntity instanceof class_5354, new AngerAbility());
        AbilityRegistry.registerByTag(class_3483.field_19168, new RaidAbility<class_1309>());
        AbilityRegistry.registerByPredicate(entity -> entity instanceof class_1496 && !(entity instanceof class_1501), new JumpAbility());
        AbilityRegistry.registerByClass(class_1545.class, new ShootFireballAbility(class_1802.field_8183, false));
        AbilityRegistry.registerByPredicate(entity -> entity instanceof class_1548 && !((class_1548)entity).method_61492(), new ExplosionAbility());
        AbilityRegistry.registerByPredicate(entity -> entity instanceof class_1548 && ((class_1548)entity).method_61492(), new ExplosionAbility(6.0f));
        AbilityRegistry.registerByClass(class_1510.class, new ShootDragonFireball());
        AbilityRegistry.registerByClass(class_1560.class, new TeleportationAbility());
        AbilityRegistry.registerByClass(class_1571.class, new ShootFireballAbility(class_1802.field_8814, true));
        AbilityRegistry.registerByClass(class_1473.class, new ShootSnowballAbility());
        AbilityRegistry.registerByClass(class_1528.class, new WitherAbility());
        AbilityRegistry.registerByClass(class_10730.class, new ClearEffectsAbility());
        AbilityRegistry.registerByClass(class_6053.class, new GoatAbility());
        AbilityRegistry.registerByClass(class_1577.class, new GuardianAbility());
        AbilityRegistry.registerByClass(class_1559.class, new RandomTeleportationAbility());
        AbilityRegistry.registerByClass(class_1501.class, new LlamaAbility());
        AbilityRegistry.registerByClass(class_1640.class, new ThrowPotionsAbility());
        AbilityRegistry.registerByClass(class_1564.class, new EvokerAbility());
        AbilityRegistry.registerByClass(class_7260.class, new WardenAbility());
        AbilityRegistry.registerByClass(class_1493.class, new AngerAbility((class_3414)((class_10823)class_3417.field_57074.get(class_10824.class_10825.field_57093)).comp_3784().comp_349(), (class_3414)((class_10823)class_3417.field_57074.get(class_10824.class_10825.field_57090)).comp_3781().comp_349()));
        AbilityRegistry.registerByClass(class_1472.class, new SheepAbility());
        AbilityRegistry.registerByClass(class_8153.class, new SnifferAbility());
        AbilityRegistry.registerByClass(class_1428.class, new ChickenAbility());
        AbilityRegistry.registerByClass(class_1438.class, new SaturateAbility());
        AbilityRegistry.registerByClass(class_4466.class, new AngerAbility(class_3417.field_20605, class_3417.field_20604));
        AbilityRegistry.registerByClass(class_1606.class, new ShulkerAbility());
        AbilityRegistry.registerByClass(class_1454.class, new PufferfishAbility());
        AbilityRegistry.registerByClass(class_1481.class, new TurtleAbility());
        AbilityRegistry.registerByClass(class_1463.class, new RabbitAbility());
        AbilityRegistry.registerByClass(class_8949.class, new BreezeAbility());
        AbilityRegistry.registerByClass(class_1613.class, new GetItemAbility(new class_1799((class_1935)class_1802.field_8107, 4)));
        class_1799 slownessArrows = new class_1799((class_1935)class_1802.field_8087, 4);
        class_1799 poisonedArrows = new class_1799((class_1935)class_1802.field_8087, 4);
        slownessArrows.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8996));
        poisonedArrows.method_57379(class_9334.field_49651, (Object)new class_1844(class_1847.field_8982));
        AbilityRegistry.registerByClass(class_9254.class, new GetItemAbility(poisonedArrows));
        AbilityRegistry.registerByClass(class_1627.class, new GetItemAbility(slownessArrows));
        Integrations.registerAbilities();
        for (GenericShapeAbility<?> ability : genericAbilities.values()) {
            if (!abilityCodecById.containsKey(ability.getId())) {
                Walkers.LOGGER.warn("{} isn't registered!", (Object)ability.getId());
            }
            if (ability.getId() != null && ability.codec() != null) continue;
            Walkers.LOGGER.warn("{} isn't correctly setup!", (Object)ability.getClass().getSimpleName());
        }
    }

    @Nullable
    public static <L extends class_1309> ShapeAbility<L> get(@NotNull L shape) {
        if (Walkers.CONFIG.abilityBlacklist.contains(class_1299.method_5890((class_1299)shape.method_5864()).toString())) {
            return null;
        }
        ShapeAbility ability = null;
        LinkedHashSet specificAbilities = new LinkedHashSet(AbilityRegistry.specificAbilities.entrySet());
        for (Map.Entry entry : specificAbilities) {
            if (!((Predicate)entry.getKey()).test(shape)) continue;
            ability = (ShapeAbility)entry.getValue();
        }
        LinkedHashSet genericAbilities = new LinkedHashSet(AbilityRegistry.genericAbilities.entrySet());
        for (Map.Entry entry : genericAbilities) {
            if (!((Predicate)entry.getKey()).test(shape)) continue;
            ability = (ShapeAbility)entry.getValue();
        }
        return ability;
    }

    public static <A extends class_1309> void registerByType(class_1299<A> type, ShapeAbility<A> ability) {
        AbilityRegistry.registerByPredicate(livingEntity -> type.equals(livingEntity.method_5864()), ability);
    }

    public static void registerByTag(class_6862<class_1299<?>> entityTag, ShapeAbility<class_1309> ability) {
        AbilityRegistry.registerByPredicate(livingEntity -> livingEntity.method_5864().method_20210(entityTag), ability);
    }

    public static <A extends class_1309> void registerByClass(@NotNull Class<A> entityClass, ShapeAbility<A> ability) {
        AbilityRegistry.registerByPredicate(entityClass::isInstance, ability);
    }

    public static void registerByPredicate(Predicate<class_1309> entityPredicate, ShapeAbility<?> ability) {
        if (ability instanceof GenericShapeAbility) {
            GenericShapeAbility genericShapeAbility = (GenericShapeAbility)ability;
            genericAbilities.put(entityPredicate, genericShapeAbility);
        } else {
            specificAbilities.put(entityPredicate, ability);
        }
    }

    public static <L extends class_1309> boolean has(@NotNull L shape) {
        if (Walkers.CONFIG.abilityBlacklist.contains(class_1299.method_5890((class_1299)shape.method_5864()).toString())) {
            return false;
        }
        return ((Stream)Stream.concat(specificAbilities.keySet().stream(), genericAbilities.keySet().stream()).parallel()).anyMatch(predicate -> predicate.test(shape));
    }

    @ApiStatus.Internal
    public static void clearAll() {
        specificAbilities.clear();
        genericAbilities.clear();
    }

    public static void registerCodec(class_2960 abilityId, MapCodec<? extends GenericShapeAbility<?>> abilityCodec) {
        abilityCodecById.put(abilityId, abilityCodec);
        abilityIdByCodec.put(abilityCodec, abilityId);
    }

    @ApiStatus.Internal
    @Nullable
    public static MapCodec<? extends GenericShapeAbility<?>> getAbilityCodec(class_2960 abilityId) {
        return abilityCodecById.get(abilityId);
    }

    @ApiStatus.Internal
    @Nullable
    public static class_2960 getAbilityId(MapCodec<? extends GenericShapeAbility<?>> traitCodec) {
        return abilityIdByCodec.get(traitCodec);
    }

    @ApiStatus.Internal
    public static Codec<GenericShapeAbility<?>> getAbilityCodec() {
        Codec codec = class_2960.field_25139.flatXmap(resourceLocation -> Optional.ofNullable(AbilityRegistry.getAbilityCodec(resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown shape ability: " + String.valueOf(resourceLocation))), abilityCodec -> Optional.ofNullable(AbilityRegistry.getAbilityId(abilityCodec)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown shape ability codec: " + String.valueOf(abilityCodec))));
        return codec.dispatchStable(GenericShapeAbility::codec, Function.identity());
    }
}

