/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.data.variants;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import dev.tocraft.craftedcore.platform.PlatformData;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.variant.NBTTypeProvider;
import dev.tocraft.walkers.api.variant.RegistryTypeProvider;
import dev.tocraft.walkers.api.variant.TypeProvider;
import dev.tocraft.walkers.api.variant.TypeProviderRegistry;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeProviderDataManager
extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().create();
    public static final Codec<TypeProviderEntry> TYPE_PROVIDER_LIST_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("entity_type").forGetter(TypeProviderEntry::entityTypeKey), (App)Codec.STRING.optionalFieldOf("required_mod", (Object)"").forGetter(o -> {
        String requiredMod = o.requiredMod();
        if (requiredMod == null) {
            return "";
        }
        return requiredMod;
    }), (App)Codec.either(NBTTypeProvider.CODEC, RegistryTypeProvider.CODEC).fieldOf("type_provider").forGetter(o -> o.providerEither)).apply((Applicative)instance, instance.stable(TypeProviderEntry::new)));

    public TypeProviderDataManager() {
        super(GSON, "walkers/variants");
    }

    protected void onApply(@NotNull Map<class_2960, JsonElement> map) {
        TypeProviderRegistry.clearAll();
        TypeProviderRegistry.registerDefault();
        for (Map.Entry<class_2960, JsonElement> mapEntry : map.entrySet()) {
            TypeProviderEntry typeProviderEntry = TypeProviderDataManager.typeProviderFromJson(mapEntry.getValue().getAsJsonObject());
            class_1299<?> entityType = typeProviderEntry.entityType();
            if (entityType == null) continue;
            TypeProviderRegistry.register(entityType, typeProviderEntry.typeProvider());
            Walkers.LOGGER.debug("{}: {} registered", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)typeProviderEntry.entityTypeKey());
        }
    }

    private static TypeProviderEntry typeProviderFromJson(JsonObject json) {
        return (TypeProviderEntry)TYPE_PROVIDER_LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(JsonParseException::new);
    }

    public record TypeProviderEntry(class_2960 entityTypeKey, @Nullable String requiredMod, Either<NBTTypeProvider<?>, RegistryTypeProvider<?, ?>> providerEither) {
        public TypeProviderEntry(class_1299<?> entityType, String requiredMod, NBTTypeProvider<?> typeProvider) {
            this(class_1299.method_5890(entityType), requiredMod, Either.left(typeProvider));
        }

        @Nullable
        public class_1299<?> entityType() {
            if ((this.requiredMod() == null || this.requiredMod().isBlank() || PlatformData.isModLoaded((String)this.requiredMod())) && class_7923.field_41177.method_10250(this.entityTypeKey())) {
                return (class_1299)((class_6880.class_6883)class_7923.field_41177.method_10223(this.entityTypeKey()).orElseThrow()).comp_349();
            }
            return null;
        }

        public TypeProvider<?> typeProvider() {
            return (TypeProvider)this.providerEither.map(n -> n, t -> t);
        }
    }
}

