/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.model;

import dev.tocraft.walkers.api.model.EntityUpdater;
import dev.tocraft.walkers.api.model.impl.AbstractHorseEntityUpdater;
import dev.tocraft.walkers.api.model.impl.ShulkerEntityUpdater;
import dev.tocraft.walkers.api.model.impl.SquidEntityUpdater;
import dev.tocraft.walkers.impl.NearbySongAccessor;
import dev.tocraft.walkers.mixin.accessor.AllayAccessor;
import dev.tocraft.walkers.mixin.accessor.BatAccessor;
import dev.tocraft.walkers.mixin.accessor.CreeperEntityAccessor;
import dev.tocraft.walkers.mixin.accessor.ParrotEntityAccessor;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1453;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class EntityUpdaters {
    private static final Map<class_1299<? extends class_1309>, EntityUpdater<? extends class_1309>> map = new LinkedHashMap<class_1299<? extends class_1309>, EntityUpdater<? extends class_1309>>();

    public static <T extends class_1309> EntityUpdater<T> getUpdater(class_1299<T> entityType) {
        return map.getOrDefault(entityType, null);
    }

    public static <T extends class_1309> void register(class_1299<T> type, EntityUpdater<T> entityUpdater) {
        map.put(type, entityUpdater);
    }

    public static void init() {
        EntityUpdaters.register(class_1299.field_6139, new AbstractHorseEntityUpdater());
        EntityUpdaters.register(class_1299.field_6067, new AbstractHorseEntityUpdater());
        EntityUpdaters.register(class_1299.field_6057, new AbstractHorseEntityUpdater());
        EntityUpdaters.register(class_1299.field_38384, (player, allay) -> {
            ((AllayAccessor)allay).setHoldingItemAnimationTicks0(((AllayAccessor)allay).getHoldingItemAnimationTicks());
            if (allay.method_43396()) {
                ((AllayAccessor)allay).setHoldingItemAnimationTicks(class_3532.method_15363((float)(((AllayAccessor)allay).getHoldingItemAnimationTicks() + 1.0f), (float)0.0f, (float)5.0f));
            } else {
                ((AllayAccessor)allay).setHoldingItemAnimationTicks(class_3532.method_15363((float)(((AllayAccessor)allay).getHoldingItemAnimationTicks() - 1.0f), (float)0.0f, (float)5.0f));
            }
        });
        EntityUpdaters.register(class_1299.field_6108, (player, bat) -> {
            bat.method_6449(!player.method_37908().method_8320(player.method_24515().method_10084()).method_26215());
            ((BatAccessor)bat).callSetupAnimationStates();
        });
        EntityUpdaters.register(class_1299.field_6104, (player, parrot) -> {
            parrot.method_6006(player.method_24515(), ((NearbySongAccessor)player).shape_isNearbySongPlaying());
            ((ParrotEntityAccessor)parrot).callCalculateFlapping();
            if (player.method_59922().method_43048(400) == 0) {
                class_1453.method_6587((class_1937)player.method_37908(), (class_1297)player);
            }
        });
        EntityUpdaters.register(class_1299.field_6091, (player, enderman) -> {
            class_1799 heldStack = player.method_6047();
            if (heldStack.method_7909() instanceof class_1747) {
                enderman.method_7032(((class_1747)heldStack.method_7909()).method_7711().method_9564());
            }
        });
        EntityUpdaters.register(class_1299.field_6046, (player, creeper) -> ((CreeperEntityAccessor)creeper).setSwell(0));
        EntityUpdaters.register(class_1299.field_6114, new SquidEntityUpdater());
        EntityUpdaters.register(class_1299.field_28402, new SquidEntityUpdater());
        EntityUpdaters.register(class_1299.field_6109, new ShulkerEntityUpdater());
        EntityUpdaters.register(class_1299.field_6132, (player, chicken) -> {
            chicken.field_6736 = chicken.field_6741;
            chicken.field_6738 = chicken.field_6743;
            chicken.field_6743 = chicken.field_6743 + (player.method_24828() ? -1.0f : 4.0f) * 0.3f;
            chicken.field_6743 = class_3532.method_15363((float)chicken.field_6743, (float)0.0f, (float)1.0f);
            if (!player.method_24828() && chicken.field_6737 < 1.0f) {
                chicken.field_6737 = 1.0f;
            }
            chicken.field_6737 *= 0.9f;
            chicken.field_6741 += chicken.field_6737 * 2.0f;
        });
        EntityUpdaters.register(class_1299.field_23214, (player, strider) -> {
            class_2680 blockState = player.method_37908().method_8320(player.method_24515());
            boolean bl = blockState.method_26164(class_3481.field_23209) || player.method_5861(class_3486.field_15518) > 0.0;
            strider.method_26349(!bl);
        });
        EntityUpdaters.register(class_1299.field_16281, (player, cat) -> cat.method_6179(false));
        EntityUpdaters.register(class_1299.field_21973, (player, hoglin) -> hoglin.method_26948(player.method_37908().method_8597().method_44220()));
        EntityUpdaters.register(class_1299.field_22281, (player, piglin) -> piglin.method_30240(player.method_37908().method_8597().method_44220()));
        EntityUpdaters.register(class_1299.field_25751, (player, piglinBrute) -> piglinBrute.method_30240(player.method_37908().method_8597().method_44220()));
    }
}

