/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.variant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.variant.TypeProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.jetbrains.annotations.NotNull;

public class NBTTypeProvider<T extends class_1309>
extends TypeProvider<T> {
    public static final MapCodec<List<class_2487>> VARIANT_DATA_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_2487.field_25128).fieldOf("variants").flatXmap(map -> {
        ArrayList variantData = new ArrayList();
        map.entrySet().stream().sorted(Comparator.comparingInt(entry -> Integer.parseInt((String)entry.getKey()))).forEach(entry -> variantData.add((class_2487)entry.getValue()));
        return DataResult.success(variantData);
    }, list -> {
        HashMap<String, class_2487> map = new HashMap<String, class_2487>();
        for (int i = 0; i < list.size(); ++i) {
            map.put(String.valueOf(i), (class_2487)list.get(i));
        }
        return DataResult.success(map);
    });
    public static final Codec<NBTTypeProvider<?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("fallback", (Object)0).forGetter(NBTTypeProvider::getFallbackData), (App)VARIANT_DATA_CODEC.forGetter(o -> o.variantData), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING).optionalFieldOf("names", new HashMap()).forGetter(o -> o.nameMap)).apply((Applicative)instance, instance.stable(NBTTypeProvider::new)));
    private final int fallback;
    private final List<class_2487> variantData;
    private final Map<String, String> nameMap;

    public NBTTypeProvider(int fallback, List<class_2487> variantData, Map<String, String> nameMap) {
        this.fallback = fallback;
        this.variantData = variantData;
        this.nameMap = nameMap;
    }

    @Override
    public int getVariantData(@NotNull T entity) {
        class_11362 out = class_11362.method_71459((class_8942)Walkers.PROBLEM_REPORTER, (class_7225.class_7874)entity.method_56673());
        entity.method_5662((class_11372)out);
        class_2487 tag = out.method_71475();
        int i = this.getData(tag);
        if (i != -1) {
            return i;
        }
        Walkers.LOGGER.error("{}: No Variant for entity type {} found.", (Object)this.getClass().getSimpleName(), (Object)class_1299.method_5890((class_1299)entity.method_5864()));
        return this.getFallbackData();
    }

    @Override
    public T create(class_1299<T> type, class_1937 world, @NotNull class_1657 player, int data) {
        class_2487 tag = new class_2487();
        this.fromData(tag, data);
        class_2487 compoundTag = tag.method_10553();
        compoundTag.method_10582("id", Objects.requireNonNull(class_1299.method_5890(type)).toString());
        return (T)((class_1309)class_1299.method_71371((class_2487)compoundTag, (class_1937)world, (class_3730)class_3730.field_52444, entity -> entity));
    }

    public int getData(class_2487 tag) {
        for (class_2487 compoundTag : this.variantData) {
            boolean bool = true;
            for (String key : compoundTag.method_10541()) {
                if (!tag.method_10545(key) || tag.method_10580(key) != compoundTag.method_10580(key)) {
                    bool = false;
                }
                if (bool) continue;
                break;
            }
            if (!bool) continue;
            return this.variantData.indexOf(compoundTag);
        }
        return -1;
    }

    public void fromData(class_2487 tag, int data) {
        if (data < this.variantData.size()) {
            for (String key : this.variantData.get(data).method_10541()) {
                class_2520 value = this.variantData.get(data).method_10580(key);
                if (value == null) continue;
                tag.method_10566(key, value);
            }
        }
    }

    @Override
    public int getFallbackData() {
        return this.fallback;
    }

    @Override
    public int size(class_1937 level) {
        return this.variantData.size();
    }

    @Override
    public class_2561 modifyText(T entity, class_5250 text) {
        if (this.nameMap.containsKey(String.valueOf(this.getVariantData(entity)))) {
            return class_2561.method_43469((String)this.nameMap.get(String.valueOf(this.getVariantData(entity))), (Object[])new Object[]{text});
        }
        return text;
    }
}

