/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.api.variant;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.variant.TypeProvider;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_10704;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.jetbrains.annotations.NotNull;

public class RegistryTypeProvider<T extends class_1309, V>
extends TypeProvider<T> {
    public static final Codec<RegistryTypeProvider<?, ?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("registry").forGetter(o -> o.registry.method_29177()), (App)Codec.INT.optionalFieldOf("fallback", (Object)0).forGetter(RegistryTypeProvider::getFallbackData)).apply((Applicative)instance, instance.stable((r, f) -> new RegistryTypeProvider(class_5321.method_29180((class_2960)r), (int)f))));
    protected final class_5321<class_2378<V>> registry;
    private final int fallback;

    public RegistryTypeProvider(class_5321<class_2378<V>> registry) {
        this(registry, 0);
    }

    public RegistryTypeProvider(class_5321<class_2378<V>> registry, int fallback) {
        this.registry = registry;
        this.fallback = fallback;
    }

    @Override
    public int getVariantData(T entity) {
        return this.getVariant(entity).flatMap(v -> this.getRegistry(entity.method_37908()).map(reg -> reg.method_10206(v.comp_349()))).orElse(this.getFallbackData());
    }

    @NotNull
    private Optional<class_6880<V>> getVariant(@NotNull T entity) {
        class_11362 out = class_11362.method_71459((class_8942)Walkers.PROBLEM_REPORTER, (class_7225.class_7874)entity.method_56673());
        entity.method_5662((class_11372)out);
        class_2487 nbt = out.method_71475();
        class_11368 in = class_11352.method_71417((class_8942)Walkers.PROBLEM_REPORTER, (class_7225.class_7874)entity.method_56673(), (class_2487)nbt);
        return class_10704.method_67178((class_11368)in, this.registry);
    }

    @Override
    public T create(@NotNull class_1299<T> type, @NotNull class_1937 level, @NotNull class_1657 player, int data) {
        class_11362 out = class_11362.method_71459((class_8942)Walkers.PROBLEM_REPORTER, (class_7225.class_7874)level.method_30349());
        out.method_71469("id", Objects.requireNonNull(class_1299.method_5890(type)).toString());
        this.getRegistry(level).flatMap(reg -> reg.method_40265(data)).ifPresent(v -> class_10704.method_67177((class_11372)out, (class_6880)v));
        return (T)((class_1309)class_1299.method_71371((class_2487)out.method_71475(), (class_1937)level, (class_3730)class_3730.field_52444, entity -> entity));
    }

    @Override
    public int getFallbackData() {
        return this.fallback;
    }

    @Override
    public int size(@NotNull class_1937 level) {
        return this.getRegistry(level).map(class_2359::method_10204).orElse(this.getFallbackData());
    }

    @Override
    public class_2561 modifyText(@NotNull T entity, class_5250 text) {
        Optional<class_5250> variant = this.getVariant(entity).flatMap(class_6880::method_40230).map(key -> class_2561.method_43470((String)this.formatTypePrefix(key.method_29177().method_12832() + " ")));
        return (class_2561)variant.map(c -> c.method_10852((class_2561)text)).orElse(text);
    }

    @NotNull
    private Optional<class_2378<V>> getRegistry(@NotNull class_1937 level) {
        Optional reg = level.method_30349().method_46759(this.registry);
        if (reg.isEmpty()) {
            Walkers.LOGGER.error("{}: Could not find registry {}", (Object)RegistryTypeProvider.class.getSimpleName(), this.registry);
        }
        return reg;
    }
}

