/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.tocraft.craftedcore.event.common.CommandEvents;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerAbilities;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.PlayerShapeChanger;
import dev.tocraft.walkers.api.variant.ShapeType;
import dev.tocraft.walkers.command.EntityBlacklistCommands;
import dev.tocraft.walkers.command.PlayerBlacklistCommands;
import dev.tocraft.walkers.impl.PlayerDataProvider;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2321;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8942;
import org.jetbrains.annotations.Nullable;

public class WalkersCommand {
    public static void initialize() {
        CommandEvents.REGISTRATION.register((dispatcher, ctx, selection) -> WalkersCommand.register((CommandDispatcher<class_2168>)dispatcher, ctx));
    }

    private static void register(CommandDispatcher<class_2168> dispatcher, class_7157 ctx) {
        LiteralCommandNode rootNode = ((LiteralArgumentBuilder)class_2170.method_9247((String)"walkers").requires(source -> source.method_9259(2))).build();
        LiteralCommandNode remove2ndShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"remove2ndShape").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(context -> {
            for (class_3222 player : class_2186.method_9312((CommandContext)context, (String)"players")) {
                WalkersCommand.remove2ndShape((class_2168)context.getSource(), player);
            }
            return 1;
        }))).build();
        LiteralCommandNode change2ndShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"change2ndShape").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> {
            class_1297 entity = class_2186.method_9313((CommandContext)context, (String)"entity");
            class_11362 out = class_11362.method_71459((class_8942)Walkers.PROBLEM_REPORTER, (class_7225.class_7874)((class_2168)context.getSource()).method_30497());
            entity.method_5647((class_11372)out);
            for (class_3222 player : class_2186.method_9312((CommandContext)context, (String)"players")) {
                WalkersCommand.change2ndShape((class_2168)context.getSource(), player, class_1299.method_5890((class_1299)entity.method_5864()), out.method_71475());
            }
            return 1;
        }))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"shape", (ArgumentType)class_7733.method_45603((class_7157)ctx, (class_5321)class_7924.field_41266)).suggests(class_2321.method_71942((SuggestionProvider)class_2321.field_10935)).executes(context -> {
            for (class_3222 player : class_2186.method_9312((CommandContext)context, (String)"players")) {
                WalkersCommand.change2ndShape((class_2168)context.getSource(), player, class_7733.method_45609((CommandContext)context, (String)"shape").method_40237().method_29177(), null);
            }
            return 1;
        })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
            class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
            for (class_3222 player : class_2186.method_9312((CommandContext)context, (String)"players")) {
                WalkersCommand.change2ndShape((class_2168)context.getSource(), player, class_7733.method_45609((CommandContext)context, (String)"shape").method_40237().method_29177(), nbt);
            }
            return 1;
        }))))).build();
        LiteralCommandNode switchShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"switchShape").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"normal").executes(context -> {
            for (class_3222 player : class_2186.method_9312((CommandContext)context, (String)"players")) {
                WalkersCommand.switchShapeToNormal((class_2168)context.getSource(), player);
            }
            return 1;
        }))).then(class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).executes(context -> {
            class_1297 entity = class_2186.method_9313((CommandContext)context, (String)"entity");
            class_11362 out = class_11362.method_71459((class_8942)Walkers.PROBLEM_REPORTER, (class_7225.class_7874)((class_2168)context.getSource()).method_30497());
            entity.method_5647((class_11372)out);
            for (class_3222 player : class_2186.method_9312((CommandContext)context, (String)"players")) {
                WalkersCommand.switchShape((class_2168)context.getSource(), player, class_1299.method_5890((class_1299)entity.method_5864()), out.method_71475());
            }
            return 1;
        }))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"shape", (ArgumentType)class_7733.method_45603((class_7157)ctx, (class_5321)class_7924.field_41266)).suggests(class_2321.method_71942((SuggestionProvider)class_2321.field_10935)).executes(context -> {
            for (class_3222 player : class_2186.method_9312((CommandContext)context, (String)"players")) {
                WalkersCommand.switchShape((class_2168)context.getSource(), player, class_7733.method_45609((CommandContext)context, (String)"shape").method_40237().method_29177(), null);
            }
            return 1;
        })).then(class_2170.method_9244((String)"nbt", (ArgumentType)class_2179.method_9284()).executes(context -> {
            class_2487 nbt = class_2179.method_9285((CommandContext)context, (String)"nbt");
            for (class_3222 player : class_2186.method_9312((CommandContext)context, (String)"players")) {
                WalkersCommand.switchShape((class_2168)context.getSource(), player, class_7733.method_45609((CommandContext)context, (String)"shape").method_40237().method_29177(), nbt);
            }
            return 1;
        }))))).build();
        LiteralCommandNode show2ndShape = ((LiteralArgumentBuilder)class_2170.method_9247((String)"show2ndShape").then(class_2170.method_9244((String)"players", (ArgumentType)class_2186.method_9308()).executes(context -> {
            for (class_3222 player : class_2186.method_9312((CommandContext)context, (String)"players")) {
                WalkersCommand.show2ndShape((class_2168)context.getSource(), player);
            }
            return 1;
        }))).build();
        rootNode.addChild((CommandNode)remove2ndShape);
        rootNode.addChild((CommandNode)change2ndShape);
        rootNode.addChild((CommandNode)switchShape);
        rootNode.addChild((CommandNode)show2ndShape);
        rootNode.addChild(PlayerBlacklistCommands.getRootNode());
        rootNode.addChild(EntityBlacklistCommands.getRootNode(ctx));
        dispatcher.getRoot().addChild((CommandNode)rootNode);
    }

    private static void show2ndShape(class_2168 source, class_3222 player) {
        if (((PlayerDataProvider)player).walkers$get2ndShape() != null) {
            ShapeType<?> type = ((PlayerDataProvider)player).walkers$get2ndShape();
            if (type != null) {
                source.method_9226(() -> class_2561.method_43469((String)"walkers.show2ndShapeNot_positive", (Object[])new Object[]{player.method_5476(), ShapeType.createTooltipText(type.create((class_1937)player.method_51469(), (class_1657)player))}), false);
            }
        } else {
            source.method_9226(() -> class_2561.method_43469((String)"walkers.show2ndShapeNot_failed", (Object[])new Object[]{player.method_5476()}), false);
        }
    }

    private static void remove2ndShape(class_2168 source, class_3222 player) {
        WalkersCommand.change2ndShape(player, null);
        player.method_7353((class_2561)class_2561.method_43471((String)"walkers.remove_entity"), true);
        source.method_9226(() -> class_2561.method_43469((String)"walkers.deletion_success", (Object[])new Object[]{player.method_5476()}), false);
    }

    private static void change2ndShape(class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType<class_1299> type = ShapeType.from((class_1299)((class_6880.class_6883)class_7923.field_41177.method_10223(id).orElseThrow()).comp_349());
        class_5250 name = class_2561.method_43471((String)type.getEntityType().method_5882());
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", id.toString());
            class_3218 serverWorld = source.method_9225();
            class_1297 loaded = class_1299.method_71371((class_2487)copy, (class_1937)serverWorld, (class_3730)class_3730.field_52444, it -> it);
            if (loaded instanceof class_1309) {
                class_1309 living = (class_1309)loaded;
                type = ShapeType.from(living);
                name = ShapeType.createTooltipText(living);
            }
        }
        if (((PlayerDataProvider)player).walkers$get2ndShape() != type) {
            WalkersCommand.change2ndShape(player, type);
            player.method_7353((class_2561)class_2561.method_43469((String)"walkers.unlock_entity", (Object[])new Object[]{name}), false);
            n = name;
            source.method_9226(() -> WalkersCommand.lambda$change2ndShape$15((class_2561)n, player), false);
        } else {
            n = name;
            source.method_9226(() -> WalkersCommand.lambda$change2ndShape$16(player, (class_2561)n), false);
        }
    }

    private static void switchShape(class_2168 source, class_3222 player, class_2960 shape, @Nullable class_2487 nbt) {
        class_1297 created;
        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", shape.toString());
            class_3218 serverWorld = source.method_9225();
            created = class_1299.method_71371((class_2487)copy, (class_1937)serverWorld, (class_3730)class_3730.field_52444, it -> it);
        } else {
            class_1299 entity = (class_1299)((class_6880.class_6883)class_7923.field_41177.method_10223(shape).orElseThrow()).comp_349();
            created = entity.method_5883((class_1937)player.method_51469(), class_3730.field_52444);
        }
        if (created instanceof class_1309) {
            ((PlayerDataProvider)player).walkers$updateShapes((class_1309)created);
            source.method_9226(() -> class_2561.method_43469((String)"walkers.switchShape_success", (Object[])new Object[]{player.method_5476(), class_2561.method_43471((String)created.method_5864().method_5882())}), false);
        }
    }

    private static void switchShapeToNormal(class_2168 source, class_3222 player) {
        boolean result = PlayerShape.updateShapes(player, null);
        if (result) {
            source.method_9226(() -> class_2561.method_43469((String)"walkers.switchShape_human_success", (Object[])new Object[]{player.method_5476()}), false);
        }
    }

    private static void change2ndShape(class_3222 player, ShapeType<?> newShape) {
        ((PlayerDataProvider)player).walkers$set2ndShape(newShape);
        PlayerShapeChanger.sync(player);
        PlayerAbilities.sync(player);
    }

    private static /* synthetic */ class_2561 lambda$change2ndShape$16(class_3222 player, class_2561 n) {
        return class_2561.method_43469((String)"walkers.already_has", (Object[])new Object[]{player.method_5476(), n});
    }

    private static /* synthetic */ class_2561 lambda$change2ndShape$15(class_2561 n, class_3222 player) {
        return class_2561.method_43469((String)"walkers.grant_success", (Object[])new Object[]{n, player.method_5476()});
    }
}

