/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.integrations;

import dev.tocraft.craftedcore.platform.PlatformData;
import dev.tocraft.walkers.integrations.AbstractIntegration;
import dev.tocraft.walkers.integrations.impl.AlexMobsIntegration;
import dev.tocraft.walkers.integrations.impl.GuardVillagersIntegration;
import dev.tocraft.walkers.integrations.impl.MobBattleModIntegration;
import dev.tocraft.walkers.integrations.impl.MoreMobVariantsIntegration;
import dev.tocraft.walkers.integrations.impl.MutantMonstersIntegration;
import dev.tocraft.walkers.integrations.impl.PlayerAbilityLibIntegration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import org.jetbrains.annotations.ApiStatus;

public class Integrations {
    private static final Map<String, AbstractIntegration> INTEGRATIONS = new HashMap<String, AbstractIntegration>();

    @ApiStatus.Internal
    public static void initIntegrations() {
        Integrations.register("mobbattle", MobBattleModIntegration::new);
        Integrations.register("guardvillagers", GuardVillagersIntegration::new);
        Integrations.register("moremobvariants", MoreMobVariantsIntegration::new);
        Integrations.register("mutantmonsters", MutantMonstersIntegration::new);
        Integrations.register("alexsmobs", AlexMobsIntegration::new);
        Integrations.register("playerabilitylib", PlayerAbilityLibIntegration::new);
    }

    @ApiStatus.Internal
    public static void registerAbilities() {
        for (AbstractIntegration loadedIntegration : INTEGRATIONS.values()) {
            loadedIntegration.registerAbilities();
        }
    }

    @ApiStatus.Internal
    public static void registerTraits() {
        for (AbstractIntegration loadedIntegration : INTEGRATIONS.values()) {
            loadedIntegration.registerTraits();
        }
    }

    @ApiStatus.Internal
    public static void registerTypeProvider() {
        for (AbstractIntegration loadedIntegration : INTEGRATIONS.values()) {
            loadedIntegration.registerTypeProvider();
        }
    }

    @ApiStatus.Internal
    public static void registerEntityBlacklist() {
        for (AbstractIntegration loadedIntegration : INTEGRATIONS.values()) {
            loadedIntegration.registerEntityBlacklist();
        }
    }

    @ApiStatus.Internal
    public static void initialize() {
        for (AbstractIntegration loadedIntegration : INTEGRATIONS.values()) {
            loadedIntegration.initialize();
        }
    }

    @ApiStatus.Internal
    public static boolean mightAttackInnocent(class_1308 mob, class_1657 target) {
        boolean bool = true;
        for (AbstractIntegration loadedIntegration : INTEGRATIONS.values()) {
            bool = bool && loadedIntegration.mightAttackInnocent(mob, target);
        }
        return bool;
    }

    public static void register(String modid, AbstractIntegration integration) {
        Integrations.register(modid, () -> integration);
    }

    public static void register(String modid, Supplier<AbstractIntegration> integration) {
        if (PlatformData.isModLoaded((String)modid)) {
            INTEGRATIONS.put(modid, integration.get());
        }
    }
}

