/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.PlayerShape;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class DisableSlotsMixin {
    @Inject(method={"getItemBySlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetAmorItem(@NotNull class_1304 slot, CallbackInfoReturnable<class_1799> cir) {
        if (slot.method_46643() && this.walkers$blockEquipSlot(slot)) {
            cir.setReturnValue((Object)class_1799.field_8037);
        }
    }

    @Inject(method={"canUseSlot"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCanUseSlot(@NotNull class_1304 slot, CallbackInfoReturnable<Boolean> cir) {
        if (slot.method_46643() && this.walkers$blockEquipSlot(slot)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private boolean walkers$blockEquipSlot(class_1304 slot) {
        DisableSlotsMixin disableSlotsMixin = this;
        if (disableSlotsMixin instanceof class_1657) {
            class_1657 player = (class_1657)disableSlotsMixin;
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape == null) {
                return false;
            }
            String shapeKey = class_1299.method_5890((class_1299)shape.method_5864()).toString();
            HashSet<String> blockedSlots = new HashSet<String>(this.walkers$getBlockedSlots("*"));
            blockedSlots.addAll(this.walkers$getBlockedSlots(shapeKey));
            return blockedSlots.contains(slot.method_5923());
        }
        return false;
    }

    @Unique
    private List<String> walkers$getBlockedSlots(String key) {
        return Walkers.CONFIG.blockEquipmentSlots.getOrDefault(key, Collections.emptyList());
    }
}

