/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.impl.NearbySongAccessor;
import dev.tocraft.walkers.impl.ShapeDataProvider;
import dev.tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import dev.tocraft.walkers.traits.ShapeTrait;
import dev.tocraft.walkers.traits.TraitRegistry;
import dev.tocraft.walkers.traits.impl.AttackForHealthTrait;
import dev.tocraft.walkers.traits.impl.CantFreezeTrait;
import dev.tocraft.walkers.traits.impl.ClimbBlocksTrait;
import dev.tocraft.walkers.traits.impl.FlyingTrait;
import dev.tocraft.walkers.traits.impl.ImmunityTrait;
import dev.tocraft.walkers.traits.impl.MobEffectTrait;
import dev.tocraft.walkers.traits.impl.SlowFallingTrait;
import dev.tocraft.walkers.traits.impl.StandOnFluidTrait;
import dev.tocraft.walkers.traits.impl.TemperatureTrait;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1498;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements NearbySongAccessor {
    @Shadow
    @Final
    private static class_2960 field_51996;
    @Unique
    private boolean walkers$nearbySongPlaying = false;
    @Unique
    private static final class_1322 walkers$HORSE_SPRINT_MODIFIER;

    protected LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @WrapOperation(method={"getEffectiveGravity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/core/Holder;)Z", ordinal=0)})
    private boolean slowFall(class_1309 instance, class_6880<class_1291> effect, Operation<Boolean> original) {
        class_1657 player;
        class_1309 shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (shape = PlayerShape.getCurrentShape(player = (class_1657)livingEntityMixin)) != null) {
            boolean bool = false;
            for (FlyingTrait flyingTrait : TraitRegistry.get(shape, FlyingTrait.ID).stream().map(trait -> (FlyingTrait)trait).toList()) {
                if (!flyingTrait.slowFalling) continue;
                bool = true;
                break;
            }
            if (!this.method_5715() && (bool || TraitRegistry.has(shape, SlowFallingTrait.ID))) {
                return true;
            }
        }
        return (Boolean)original.call(new Object[]{instance, effect});
    }

    @Inject(method={"causeFallDamage"}, at={@At(value="HEAD")}, cancellable=true)
    private void causeFallDamage(double fallDistance, float damageMultiplier, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (shape = PlayerShape.getCurrentShape(player = (class_1657)livingEntityMixin)) != null) {
            boolean takesFallDamage = shape.method_5747(fallDistance, damageMultiplier, damageSource);
            int damageAmount = ((LivingEntityAccessor)shape).callCalculateFallDamage(fallDistance, damageMultiplier);
            if (takesFallDamage && damageAmount > 0) {
                class_1309.class_6823 fallSounds = shape.method_39760();
                this.method_5783(damageAmount > 4 ? fallSounds.comp_302() : fallSounds.comp_301(), 1.0f, 1.0f);
                ((LivingEntityAccessor)shape).callPlayBlockFallSound();
                this.method_64419(this.method_48923().method_48827(), damageAmount);
                cir.setReturnValue((Object)true);
            } else {
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"hasEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnHasNightVision(class_6880<class_1291> effect, CallbackInfoReturnable<Boolean> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657) {
            class_1657 player = (class_1657)livingEntityMixin;
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (TraitRegistry.has(shape, MobEffectTrait.ID)) {
                List<MobEffectTrait> traitList = TraitRegistry.get(shape, MobEffectTrait.ID).stream().map(trait -> (MobEffectTrait)trait).toList();
                for (MobEffectTrait mobEffectTrait : traitList) {
                    if (mobEffectTrait.showInInventory || !mobEffectTrait.applyToSelf || !effect.equals((Object)mobEffectTrait.mobEffectInstance.method_5579())) continue;
                    cir.setReturnValue((Object)true);
                    return;
                }
            }
            for (ShapeTrait<class_1309> immunityTrait : TraitRegistry.get(shape, ImmunityTrait.ID)) {
                if (!((ImmunityTrait)immunityTrait).effect.equals(effect.comp_349())) continue;
                cir.setReturnValue((Object)false);
                return;
            }
        }
    }

    @Inject(method={"getEffect"}, at={@At(value="HEAD")}, cancellable=true)
    private void returnNightVisionInstance(class_6880<class_1291> effect, CallbackInfoReturnable<class_1293> cir) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657) {
            class_1657 player = (class_1657)livingEntityMixin;
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (TraitRegistry.has(shape, MobEffectTrait.ID)) {
                List<MobEffectTrait> traitList = TraitRegistry.get(shape, MobEffectTrait.ID).stream().map(trait -> (MobEffectTrait)trait).toList();
                for (MobEffectTrait mobEffectTrait : traitList) {
                    class_1293 mobEffectInstance;
                    if (mobEffectTrait.showInInventory || !mobEffectTrait.applyToSelf || !effect.equals((Object)(mobEffectInstance = mobEffectTrait.mobEffectInstance).method_5579())) continue;
                    cir.setReturnValue((Object)new class_1293(mobEffectInstance.method_5579(), mobEffectInstance.method_5584(), mobEffectInstance.method_5578(), mobEffectInstance.method_5591(), mobEffectInstance.method_5581(), mobEffectInstance.method_5592()));
                    return;
                }
            }
            for (ShapeTrait<class_1309> immunityTrait : TraitRegistry.get(shape, ImmunityTrait.ID)) {
                if (!((ImmunityTrait)immunityTrait).effect.equals(effect.comp_349())) continue;
                cir.setReturnValue(null);
                return;
            }
        }
    }

    @Inject(method={"isSensitiveToWater"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_isSensitiveToWater(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 entity;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (entity = PlayerShape.getCurrentShape(player = (class_1657)class_13092)) != null) {
            cir.setReturnValue((Object)entity.method_29503());
        }
    }

    @Inject(method={"setRecordPlayingNearby"}, at={@At(value="RETURN")})
    @Environment(value=EnvType.CLIENT)
    protected void shape_setRecordPlayingNearby(class_2338 songPosition, boolean playing, CallbackInfo ci) {
        if ((class_1309)this instanceof class_1657) {
            this.walkers$nearbySongPlaying = playing;
        }
    }

    @Override
    public boolean shape_isNearbySongPlaying() {
        return this.walkers$nearbySongPlaying;
    }

    @Inject(method={"isInvertedHealAndHarm"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_isInvertedHealAndHarm(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 shape;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (shape = PlayerShape.getCurrentShape(player = (class_1657)class_13092)) != null) {
            cir.setReturnValue((Object)shape.method_5999());
        }
    }

    @Inject(method={"canStandOnFluid"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_canStandOnFluid(class_3610 state, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 shape;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (shape = PlayerShape.getCurrentShape(player = (class_1657)class_13092)) != null) {
            if (shape.method_26319(state)) {
                cir.setReturnValue((Object)true);
            } else {
                for (StandOnFluidTrait standOnFluidTrait : TraitRegistry.get(shape, StandOnFluidTrait.ID).stream().map(entry -> (StandOnFluidTrait)entry).toList()) {
                    if (!state.method_15767(standOnFluidTrait.fluidTagKey)) continue;
                    cir.setReturnValue((Object)true);
                    return;
                }
            }
        }
    }

    @Inject(method={"onClimbable"}, at={@At(value="HEAD")}, cancellable=true)
    protected void shape_allowSpiderClimbing(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 shape;
        class_1309 class_13092 = (class_1309)this;
        if (class_13092 instanceof class_1657 && (shape = PlayerShape.getCurrentShape(player = (class_1657)class_13092)) != null) {
            class_2680 blockState = this.method_37908().method_8320(this.method_24515());
            for (ClimbBlocksTrait climbBlocksTrait : TraitRegistry.get(shape, ClimbBlocksTrait.ID).stream().map(entry -> (ClimbBlocksTrait)entry).toList()) {
                for (class_2248 invalidBlock : climbBlocksTrait.invalidBlocks) {
                    if (!blockState.method_27852(invalidBlock)) continue;
                    return;
                }
                if (climbBlocksTrait.validBlocks.isEmpty()) {
                    cir.setReturnValue((Object)this.field_5976);
                    continue;
                }
                for (class_2248 validBlock : climbBlocksTrait.validBlocks) {
                    if (!blockState.method_27852(validBlock)) continue;
                    cir.setReturnValue((Object)(!climbBlocksTrait.horizontalCollision || this.field_5976 ? 1 : 0));
                    return;
                }
            }
        }
    }

    @Inject(method={"isSensitiveToWater"}, at={@At(value="RETURN")}, cancellable=true)
    private void handleWaterSensitivity(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player;
        class_1309 shape;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && (shape = PlayerShape.getCurrentShape(player = (class_1657)livingEntityMixin)) != null) {
            cir.setReturnValue((Object)shape.method_29503());
        }
    }

    @Inject(method={"canFreeze"}, at={@At(value="RETURN")}, cancellable=true)
    private void temperatureTraitPreventFreeze(@NotNull CallbackInfoReturnable<Boolean> cir) {
        class_1309 shape;
        if (((Boolean)cir.getReturnValue()).booleanValue() && this instanceof class_1657 && (shape = PlayerShape.getCurrentShape((class_1657)this)) != null) {
            if (TraitRegistry.has(shape, CantFreezeTrait.ID)) {
                cir.setReturnValue((Object)false);
            } else {
                for (ShapeTrait<class_1309> temperatureTrait : TraitRegistry.get(shape, TemperatureTrait.ID)) {
                    if (!((TemperatureTrait)temperatureTrait).coldEnoughToSnow) continue;
                    cir.setReturnValue((Object)false);
                }
            }
        }
    }

    @Inject(method={"hurtServer"}, at={@At(value="HEAD")}, cancellable=true)
    private void setPlayerSource(class_3218 serverLevel, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 player;
        class_1308 mobEntity;
        int playerId;
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1308 && (playerId = ((ShapeDataProvider)(mobEntity = (class_1308)attacker)).walkers$shapedPlayer()) != -1 && (player = serverLevel.method_8469(playerId)) instanceof class_1657) {
            class_1282 damageSource = serverLevel.method_48963().method_48802((class_1657)player);
            cir.setReturnValue((Object)this.method_64397(serverLevel, damageSource, amount));
        }
    }

    @Inject(method={"hurtServer"}, at={@At(value="RETURN")})
    private void attackForHealthTrait(class_3218 serverLevel, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            boolean didHurtTarget = (Boolean)cir.getReturnValue();
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (didHurtTarget && TraitRegistry.has(shape, AttackForHealthTrait.ID)) {
                player.method_6025(Math.max(1.0f, amount / 2.0f));
            }
        }
    }

    @ModifyArg(method={"setSprinting"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ai/attributes/AttributeInstance;addTransientModifier(Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;)V"), index=0)
    private class_1322 modifyHorseSprint(class_1322 original) {
        class_1657 player;
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof class_1657 && PlayerShape.getCurrentShape(player = (class_1657)livingEntityMixin) instanceof class_1498 && original.comp_2447().equals((Object)field_51996)) {
            return walkers$HORSE_SPRINT_MODIFIER;
        }
        return original;
    }

    static {
        walkers$HORSE_SPRINT_MODIFIER = new class_1322(field_51996, 0.5, class_1322.class_1323.field_6331);
    }
}

