/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin.player;

import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.api.FlightHelper;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.api.variant.ShapeType;
import dev.tocraft.walkers.impl.PlayerDataProvider;
import dev.tocraft.walkers.mixin.EntityTrackerAccessor;
import dev.tocraft.walkers.mixin.ThreadedAnvilChunkStorageAccessor;
import dev.tocraft.walkers.traits.TraitRegistry;
import dev.tocraft.walkers.traits.impl.RiderTrait;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityDataMixin
extends class_1309
implements PlayerDataProvider {
    @Unique
    private static final String ABILITY_COOLDOWN_KEY = "AbilityCooldown";
    @Unique
    @Nullable
    private ShapeType<?> walkers$unlocked;
    @Unique
    private int walkers$remainingTime = 0;
    @Unique
    private int walkers$abilityCooldown = 0;
    @Unique
    @Nullable
    private class_1309 walkers$shape = null;
    @Unique
    private float walkers$normalHealth = -1.0f;

    private PlayerEntityDataMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void readNbt(class_11368 in, CallbackInfo ci) {
        class_11368 unlockedShape = in.method_71434("UnlockedShape");
        this.walkers$unlocked = ShapeType.from(unlockedShape);
        this.walkers$abilityCooldown = in.method_71439(ABILITY_COOLDOWN_KEY).orElse(0);
        this.walkers$remainingTime = in.method_71439("RemainingHostilityTime").orElse(0);
        this.walkers$normalHealth = in.method_71423("walkersHealth", -1.0f);
        this.walkers$readCurrentShape(in.method_71434("CurrentShape"));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void writeNbt(class_11372 out, CallbackInfo ci) {
        class_2487 id = new class_2487();
        if (this.walkers$unlocked != null) {
            id = this.walkers$unlocked.writeCompound();
        }
        out.method_71468("UnlockedShape", class_2487.field_25128, (Object)id);
        out.method_71465(ABILITY_COOLDOWN_KEY, this.walkers$abilityCooldown);
        out.method_71465("RemainingHostilityTime", this.walkers$remainingTime);
        out.method_71464("walkersHealth", this.walkers$normalHealth);
        this.walkers$writeCurrentShape(out.method_71461("CurrentShape"));
    }

    @Unique
    private void walkers$writeCurrentShape(@NotNull class_11372 out) {
        class_11372 shapeOut = out.method_71461("EntityData");
        if (this.walkers$shape != null) {
            this.walkers$shape.method_5647(shapeOut);
        }
        out.method_71469("id", this.walkers$shape == null ? "minecraft:empty" : class_1299.method_5890((class_1299)this.walkers$shape.method_5864()).toString());
    }

    @Unique
    public void walkers$readCurrentShape(class_11368 in) {
        Optional entityTag;
        Optional type = class_1299.method_17684((class_11368)in);
        if (in.method_71441("id").map(it -> it.equals("minecraft:empty")).orElse(false).booleanValue()) {
            this.walkers$shape = null;
            this.method_18382();
        } else if (type.isPresent() && (entityTag = in.method_71420("EntityData")).isPresent()) {
            if (this.walkers$shape == null || !((class_1299)type.get()).equals(this.walkers$shape.method_5864())) {
                this.walkers$shape = (class_1309)((class_1299)type.get()).method_5883(this.method_37908(), class_3730.field_52444);
                this.method_18382();
            }
            if (this.walkers$shape != null) {
                this.walkers$shape.method_5651((class_11368)entityTag.get());
            }
        }
    }

    @Override
    @Unique
    @Nullable
    public ShapeType<?> walkers$get2ndShape() {
        return this.walkers$unlocked;
    }

    @Override
    public void walkers$set2ndShape(ShapeType<?> unlocked) {
        this.walkers$unlocked = unlocked;
    }

    @Override
    @Unique
    public int walkers$getRemainingHostilityTime() {
        return this.walkers$remainingTime;
    }

    @Override
    @Unique
    public void walkers$setRemainingHostilityTime(int max) {
        this.walkers$remainingTime = max;
    }

    @Override
    @Unique
    public int walkers$getAbilityCooldown() {
        return this.walkers$abilityCooldown;
    }

    @Override
    @Unique
    public void walkers$setAbilityCooldown(int abilityCooldown) {
        this.walkers$abilityCooldown = abilityCooldown;
    }

    @Override
    @Unique
    @Nullable
    public class_1309 walkers$getCurrentShape() {
        return this.walkers$shape;
    }

    @Override
    @Unique
    public void walkers$setCurrentShape(class_1309 shape) {
        this.walkers$shape = shape;
    }

    @Override
    @Unique
    public void walkers$updateShapes(@Nullable class_1309 shape) {
        class_1297 playerStepHeightAttr;
        class_1937 class_19372;
        class_1657 player = (class_1657)this;
        class_1324 healthAttribute = player.method_5996(class_5134.field_23716);
        class_1324 armorAttribute = player.method_5996(class_5134.field_23724);
        class_1324 armorToughnessAttribute = player.method_5996(class_5134.field_23725);
        if (Walkers.CONFIG.emit_particles && this.walkers$shape != shape && (class_19372 = player.method_37908()) instanceof class_3218) {
            class_3218 l = (class_3218)class_19372;
            l.method_65096((class_2394)class_2398.field_11220, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 25, 0.5, 1.0, 0.5, 0.5);
            l.method_65096((class_2394)class_2398.field_11214, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 25, 0.5, 1.0, 0.5, 0.5);
            l.method_65096((class_2394)class_2398.field_29644, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 25, 0.5, 1.0, 0.5, 0.5);
        }
        this.walkers$shape = shape;
        if (shape != null) {
            if (Walkers.CONFIG.scalingHealth && healthAttribute != null) {
                this.walkers$normalHealth = player.method_6063();
                float currentHealthPercent = player.method_6032() / player.method_6063();
                healthAttribute.method_6192((double)Math.min((float)Walkers.CONFIG.maxHealth, shape.method_6063()));
                if (Walkers.CONFIG.percentScalingHealth) {
                    player.method_6033(Math.min(currentHealthPercent * player.method_6063(), player.method_6063()));
                } else {
                    player.method_6033(Math.min(player.method_6032(), player.method_6063()));
                }
            }
            if (Walkers.CONFIG.scalingAmor) {
                class_1324 shapeArmorAttribute = shape.method_5996(class_5134.field_23724);
                if (armorAttribute != null && shapeArmorAttribute != null) {
                    armorAttribute.method_6192(Math.min((double)Walkers.CONFIG.maxAmor, shapeArmorAttribute.method_6201()));
                }
                class_1324 shapeArmorToughnessAttribute = shape.method_5996(class_5134.field_23725);
                if (armorToughnessAttribute != null && shapeArmorToughnessAttribute != null) {
                    armorToughnessAttribute.method_6192(Math.min((double)Walkers.CONFIG.maxAmorToughness, shapeArmorToughnessAttribute.method_6201()));
                }
            }
            class_1324 playerScaleAttribute = player.method_5996(class_5134.field_47760);
            class_1324 shapeScaleAttribute = shape.method_5996(class_5134.field_47760);
            if (playerScaleAttribute != null && shapeScaleAttribute != null) {
                shapeScaleAttribute.method_6192(playerScaleAttribute.method_6201());
            }
            if (Walkers.CONFIG.scalingStepHeight && (playerStepHeightAttr = player.method_5996(class_5134.field_47761)) != null) {
                playerStepHeightAttr.method_6192((double)shape.method_49476());
            }
        }
        player.method_18382();
        if (shape == null) {
            class_1324 playerStepHeightAttr2;
            if (Walkers.CONFIG.scalingHealth && healthAttribute != null) {
                float currentHealthPercent = player.method_6032() / player.method_6063();
                float health = Walkers.CONFIG.player_health;
                if (health < 0.0f) {
                    health = this.walkers$normalHealth > 0.0f ? this.walkers$normalHealth : 20.0f;
                }
                healthAttribute.method_6192((double)health);
                if (Walkers.CONFIG.percentScalingHealth) {
                    player.method_6033(Math.min(currentHealthPercent * player.method_6063(), player.method_6063()));
                } else {
                    player.method_6033(Math.min(player.method_6032(), player.method_6063()));
                }
            }
            if (Walkers.CONFIG.scalingAmor) {
                if (armorAttribute != null) {
                    armorAttribute.method_6192(0.0);
                }
                if (armorToughnessAttribute != null) {
                    armorAttribute.method_6192(0.0);
                }
            }
            if (Walkers.CONFIG.scalingStepHeight && (playerStepHeightAttr2 = player.method_5996(class_5134.field_47761)) != null) {
                playerStepHeightAttr2.method_6192(0.6);
            }
        }
        class_3222 serverPlayer = (class_3222)player;
        if (Walkers.hasFlyingPermissions((class_3222)player)) {
            FlightHelper.grantFlightTo(serverPlayer);
            FlightHelper.updateFlyingSpeed(player);
            player.method_7355();
        } else if (!player.method_68878()) {
            FlightHelper.revokeFlight(serverPlayer);
            player.method_31549().method_7248(0.05f);
            player.method_7355();
        }
        playerStepHeightAttr = player.method_5854();
        if (playerStepHeightAttr instanceof class_1309) {
            class_1309 livingVehicle = (class_1309)playerStepHeightAttr;
            boolean b1 = false;
            boolean b2 = false;
            for (RiderTrait riderTrait : TraitRegistry.get(shape, RiderTrait.ID).stream().map(entry -> (RiderTrait)entry).toList()) {
                class_1657 rideablePlayer;
                if (riderTrait.isRideable(livingVehicle) || livingVehicle instanceof class_1657 && riderTrait.isRideable(PlayerShape.getCurrentShape(rideablePlayer = (class_1657)livingVehicle))) {
                    b1 = true;
                    b2 = true;
                }
                if (!b2) continue;
                break;
            }
            if (!b1) {
                player.method_5848();
            }
        }
        if (!(shape instanceof class_1496)) {
            for (class_1297 passenger : player.method_5685()) {
                passenger.method_5848();
            }
        }
        if (!player.method_37908().field_9236) {
            PlayerShape.sync((class_3222)player);
            Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor)((class_3218)player.method_37908()).method_14178().field_17254).getEntityMap();
            Object tracking = trackers.get(player.method_5628());
            ((EntityTrackerAccessor)tracking).getSeenBy().forEach(listener -> PlayerShape.sync((class_3222)player, listener.method_32311()));
        }
    }
}

