/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.mixin.player;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import dev.tocraft.walkers.api.PlayerShape;
import dev.tocraft.walkers.mixin.LivingEntityMixin;
import dev.tocraft.walkers.mixin.accessor.EntityAccessor;
import dev.tocraft.walkers.mixin.accessor.IronGolemEntityAccessor;
import dev.tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import dev.tocraft.walkers.mixin.accessor.RavagerEntityAccessor;
import dev.tocraft.walkers.traits.ShapeTrait;
import dev.tocraft.walkers.traits.TraitRegistry;
import dev.tocraft.walkers.traits.impl.AttackForHealthTrait;
import dev.tocraft.walkers.traits.impl.BurnInDaylightTrait;
import dev.tocraft.walkers.traits.impl.HumanoidTrait;
import dev.tocraft.walkers.traits.impl.InstantDieOnDamageMsgTrait;
import dev.tocraft.walkers.traits.impl.InvulnerabilityTrait;
import dev.tocraft.walkers.traits.impl.ReinforcementsTrait;
import dev.tocraft.walkers.traits.impl.TemperatureTrait;
import java.util.Iterator;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1439;
import net.minecraft.class_1454;
import net.minecraft.class_1584;
import net.minecraft.class_1621;
import net.minecraft.class_1628;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2668;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_4019;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4466;
import net.minecraft.class_5134;
import net.minecraft.class_7260;
import net.minecraft.class_8103;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends LivingEntityMixin {
    private PlayerEntityMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"getDefaultDimensions"}, at={@At(value="HEAD")}, cancellable=true)
    private void getDimensions(class_4050 pose, CallbackInfoReturnable<class_4048> cir) {
        class_1309 entity = PlayerShape.getCurrentShape((class_1657)this);
        if (!(entity == null || pose == class_4050.field_18081 && TraitRegistry.has(entity, HumanoidTrait.ID))) {
            class_4048 shapeDimensions = entity.method_18377(pose);
            cir.setReturnValue((Object)shapeDimensions);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")})
    protected void shape_tryAttack(class_1297 target, CallbackInfo ci) {
        class_4466 bee;
        class_1309 shape = PlayerShape.getCurrentShape((class_1657)this);
        if (shape instanceof class_1439) {
            class_1439 golem = (class_1439)shape;
            ((IronGolemEntityAccessor)golem).setAttackTicksLeft(10);
        } else if (shape instanceof class_7260) {
            class_7260 warden = (class_7260)shape;
            warden.field_38137.method_41322(this.field_6012);
        } else if (shape instanceof class_1584) {
            class_1584 ravager = (class_1584)shape;
            ((RavagerEntityAccessor)ravager).setAttackTick(10);
        } else if (shape instanceof class_1639 && target instanceof class_1309) {
            class_1309 livingTarget = (class_1309)target;
            livingTarget.method_37222(new class_1293(class_1294.field_5920, 200), (class_1297)this);
        } else if (shape instanceof class_4466 && (bee = (class_4466)shape).method_29511() && target instanceof class_1309) {
            class_1309 livingTarget = (class_1309)target;
            livingTarget.method_37222(new class_1293(class_1294.field_5899, 200), (class_1297)this);
        } else if (shape instanceof class_1454) {
            class_1454 pufferfish = (class_1454)shape;
            if (!this.method_37908().field_9236) {
                class_1309 livingTarget;
                int i = pufferfish.method_6594();
                if (target instanceof class_1309 && (livingTarget = (class_1309)target).method_64397((class_3218)this.method_37908(), this.method_48923().method_48812((class_1309)((class_1657)this)), (float)(1 + i))) {
                    livingTarget.method_37222(new class_1293(class_1294.field_5899, 60 * i, 0), (class_1297)((class_1657)this));
                    this.method_5783(class_3417.field_14848, 1.0f, 1.0f);
                    if (livingTarget instanceof class_3222) {
                        class_3222 serverPlayerTarget = (class_3222)livingTarget;
                        if (!this.method_5701()) {
                            serverPlayerTarget.field_13987.method_14364((class_2596)new class_2668(class_2668.field_25654, 0.0f));
                        }
                    }
                }
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickGolemAttackTicks(CallbackInfo ci) {
        class_1439 golem;
        IronGolemEntityAccessor accessor;
        class_1309 shape = PlayerShape.getCurrentShape((class_1657)this);
        if (shape instanceof class_1439 && (accessor = (IronGolemEntityAccessor)(golem = (class_1439)shape)).getAttackTicksLeft() > 0) {
            accessor.setAttackTicksLeft(accessor.getAttackTicksLeft() - 1);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickRavagerAttackTicks(CallbackInfo ci) {
        class_1584 ravager;
        RavagerEntityAccessor accessor;
        class_1309 shape = PlayerShape.getCurrentShape((class_1657)this);
        if (shape instanceof class_1584 && (accessor = (RavagerEntityAccessor)(ravager = (class_1584)shape)).getAttackTick() > 0) {
            accessor.setAttackTick(accessor.getAttackTick() - 1);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickWardenSneakingAnimation(CallbackInfo ci) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657)this);
        if (shape instanceof class_7260) {
            class_7260 warden = (class_7260)shape;
            if (this.method_5715()) {
                if (!warden.field_38169.method_41327()) {
                    warden.field_38169.method_41322(this.field_6012);
                }
            } else {
                warden.field_38169.method_41325();
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickFire(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        class_1309 shape = PlayerShape.getCurrentShape(player);
        if (!player.method_37908().field_9236 && !player.method_68878() && !player.method_7325() && shape != null && TraitRegistry.has(shape, BurnInDaylightTrait.ID)) {
            boolean bl = this.walkers$isInDaylight();
            for (BurnInDaylightTrait trait2 : TraitRegistry.get(shape, BurnInDaylightTrait.ID).stream().map(trait -> (BurnInDaylightTrait)trait).toList()) {
                bl = bl && !trait2.burnInMoonlightInstead || !this.walkers$isInDaylight() && trait2.burnInMoonlightInstead;
            }
            if (bl) {
                if (player.method_37908().method_8419()) {
                    return;
                }
                class_1799 itemStack = player.method_6118(class_1304.field_6169);
                if (!itemStack.method_7960()) {
                    if (itemStack.method_7963()) {
                        itemStack.method_7974(itemStack.method_7919() + player.method_59922().method_43048(2));
                        if (itemStack.method_7919() >= itemStack.method_7936()) {
                            player.method_20235(itemStack.method_7909(), class_1304.field_6169);
                            player.method_5673(class_1304.field_6169, class_1799.field_8037);
                        }
                    }
                    bl = false;
                }
                if (bl) {
                    player.method_5639(8.0f);
                }
            }
        }
    }

    @Unique
    private boolean walkers$isInDaylight() {
        if (!this.method_37908().field_9236 && !this.method_37908().method_8597().method_29960() && this.method_37908().method_8594() < 4) {
            float brightnessAtEyes = this.method_5718();
            class_2338 daylightTestPosition = class_2338.method_49637((double)this.method_23317(), (double)Math.round(this.method_23318()), (double)this.method_23321());
            if (this.method_5854() instanceof class_1690) {
                daylightTestPosition = daylightTestPosition.method_10084();
            }
            return brightnessAtEyes > 0.5f && this.field_5974.method_43057() * 30.0f < (brightnessAtEyes - 0.4f) * 2.0f && this.method_37908().method_8311(daylightTestPosition);
        }
        return false;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickTemperature(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        class_1309 shape = PlayerShape.getCurrentShape(player);
        if (!player.method_68878() && !player.method_7325() && shape != null) {
            boolean couldEnoughToSnow = ((class_1959)this.method_37908().method_23753(this.method_24515()).comp_349()).method_33599(this.method_24515(), this.method_37908().method_8615());
            for (TemperatureTrait temperaturetrait : TraitRegistry.get(shape, TemperatureTrait.ID).stream().map(entry -> (TemperatureTrait)entry).toList()) {
                if (!temperaturetrait.coldEnoughToSnow != couldEnoughToSnow) continue;
                player.method_64419(this.method_37908().method_48963().method_48813(), 1.0f);
                break;
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickWalkers(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        class_1309 shape = PlayerShape.getCurrentShape(player);
        if (shape != null) {
            shape.method_5660(player.method_5715());
            shape.method_18380(player.method_18376());
            shape.method_5796(player.method_5681());
            if (!this.method_37908().field_9236) {
                shape.method_23327(player.method_23317(), player.method_23318(), player.method_23321());
                shape.method_5847(player.method_5791());
                shape.method_6100(((LivingEntityAccessor)player).isJumping());
                shape.method_5728(player.method_5624());
                shape.method_6097(player.method_6022());
                shape.method_5684(true);
                shape.method_5875(true);
                shape.method_5796(player.method_5681());
                shape.method_6019(player.method_6058());
                if (shape instanceof class_1321) {
                    ((class_1321)shape).method_6179(player.method_5715());
                    ((class_1321)shape).method_24346(player.method_5715());
                } else if (shape instanceof class_4019) {
                    ((class_4019)shape).method_18294(player.method_5715());
                    ((class_4019)shape).method_6100(!player.method_24828());
                }
                ((EntityAccessor)shape).shape_callSetFlag(7, player.method_6128());
                ((LivingEntityAccessor)shape).callUpdatingUsingItem();
                PlayerShape.sync((class_3222)player);
            }
        }
    }

    @Inject(method={"makeStuckInBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void onStuckInBlock(class_2680 state, class_243 motionMultiplier, CallbackInfo ci) {
        if (PlayerShape.getCurrentShape((class_1657)this) instanceof class_1628 && state.method_27852(class_2246.field_10343)) {
            ci.cancel();
        }
    }

    @Inject(method={"touch"}, at={@At(value="HEAD")})
    private void onTouch(class_1297 entity, CallbackInfo ci) {
        class_1309 class_13092;
        class_1657 ownPlayer = (class_1657)this;
        if (!this.method_37908().field_9236 && ownPlayer.method_5805() && (class_13092 = PlayerShape.getCurrentShape(ownPlayer)) instanceof class_1621) {
            class_1657 targetPlayer;
            class_1621 slimeShape = (class_1621)class_13092;
            if (entity instanceof class_1657 && !(PlayerShape.getCurrentShape(targetPlayer = (class_1657)entity) instanceof class_1621)) {
                int i = slimeShape.method_7152();
                boolean wasHurt = targetPlayer.method_64397((class_3218)this.method_37908(), ownPlayer.method_48923().method_48812((class_1309)ownPlayer), (float)ownPlayer.method_45325(class_5134.field_23721));
                if (this.method_5858((class_1297)targetPlayer) < 0.6 * (double)i * 0.6 * (double)i && ownPlayer.method_6057((class_1297)targetPlayer) && wasHurt) {
                    this.method_5783(class_3417.field_14863, 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
                    class_1890.method_60107((class_3218)((class_3218)ownPlayer.method_37908()), (class_1297)targetPlayer, (class_1282)ownPlayer.method_48923().method_48812((class_1309)ownPlayer));
                }
            }
        }
    }

    @Inject(method={"hurtServer"}, at={@At(value="HEAD")})
    private void handeReinforcementsTrait(class_3218 level, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = (class_1657)this;
        class_1309 shape = PlayerShape.getCurrentShape(player);
        Object object = source.method_5529();
        if (object instanceof class_1309) {
            class_1309 livingAttacker = (class_1309)object;
            if (shape != null && (object = TraitRegistry.get(shape, ReinforcementsTrait.ID).stream().map(trait -> (ReinforcementsTrait)trait).toList().iterator()).hasNext()) {
                ReinforcementsTrait reinforcementTrait = (ReinforcementsTrait)object.next();
                double d = reinforcementTrait.getRange();
                class_238 aABB = class_238.method_29968((class_243)this.method_19538()).method_1009(d, 10.0, d);
                Iterator var5 = level.method_8390(class_1308.class, aABB, class_1301.field_6155.and(entity -> {
                    if (reinforcementTrait.hasReinforcements()) {
                        return reinforcementTrait.isReinforcement((class_1297)entity);
                    }
                    return shape.getClass().isInstance(entity);
                })).iterator();
                while (true) {
                    boolean bl;
                    if (!var5.hasNext()) {
                        return;
                    }
                    class_1308 mob = (class_1308)var5.next();
                    if (shape == mob || mob.method_5968() != null || (bl = false)) continue;
                    mob.method_5980(livingAttacker);
                }
            }
        }
    }

    @Inject(method={"hurtServer"}, at={@At(value="HEAD")})
    private void instantDieOnDamageTypeTrait(class_3218 level, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657)this);
        if (shape != null) {
            for (ShapeTrait<class_1309> instantDieOnDamageTypetrait : TraitRegistry.get(shape, InstantDieOnDamageMsgTrait.ID)) {
                if (!source.method_5525().equals(((InstantDieOnDamageMsgTrait)instantDieOnDamageTypetrait).msgId)) continue;
                this.method_5768(level);
            }
        }
    }

    @Inject(method={"isInvulnerableTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void invulnerabilityTrait(class_3218 level, class_1282 damageSource, CallbackInfoReturnable<Boolean> cir) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657)this);
        if (!damageSource.method_48789(class_8103.field_42242) && TraitRegistry.has(shape, InvulnerabilityTrait.ID)) {
            cir.setReturnValue((Object)true);
        }
    }

    @WrapWithCondition(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/food/FoodData;tick(Lnet/minecraft/server/level/ServerPlayer;)V")})
    private boolean preventFoodDataTick(class_1702 instance, class_3222 player) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657)player);
        return player.method_6059(class_1294.field_5922) || !TraitRegistry.has(shape, AttackForHealthTrait.ID);
    }

    @Inject(method={"canEat"}, at={@At(value="RETURN")}, cancellable=true)
    private void onCanEat(boolean canAlwaysEat, CallbackInfoReturnable<Boolean> cir) {
        if (((Boolean)cir.getReturnValue()).booleanValue() && TraitRegistry.has(PlayerShape.getCurrentShape((class_1657)this), AttackForHealthTrait.ID)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"causeFoodExhaustion"}, at={@At(value="HEAD")}, cancellable=true)
    private void onExhaustion(float exhaustion, CallbackInfo ci) {
        if (TraitRegistry.has(PlayerShape.getCurrentShape((class_1657)this), AttackForHealthTrait.ID)) {
            ci.cancel();
        }
    }
}

