/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.walkers.network;

import dev.tocraft.craftedcore.client.CraftedCoreClient;
import dev.tocraft.craftedcore.network.ModernNetworking;
import dev.tocraft.craftedcore.network.client.ClientNetworking;
import dev.tocraft.walkers.Walkers;
import dev.tocraft.walkers.impl.PlayerDataProvider;
import dev.tocraft.walkers.network.NetworkHandler;
import dev.tocraft.walkers.network.impl.SyncApiLevelPackets;
import dev.tocraft.walkers.network.impl.UnlockPackets;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_11352;
import net.minecraft.class_11368;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_4844;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.jetbrains.annotations.Nullable;

public class ClientNetworking
implements NetworkHandler {
    public static void registerPacketHandlers() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (class_2960)NetworkHandler.SHAPE_SYNC, ClientNetworking::handleWalkersSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (class_2960)NetworkHandler.ABILITY_SYNC, ClientNetworking::handleAbilitySyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (class_2960)NetworkHandler.UNLOCK_SYNC, UnlockPackets::handleUnlockSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (class_2960)NetworkHandler.SYNC_API_LEVEL, (context, nbt) -> SyncApiLevelPackets.handleSyncPacket(nbt));
    }

    public static void runOrQueue(ModernNetworking.Context context, ClientNetworking.ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            CraftedCoreClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }

    public static void sendAbilityRequest() {
        ModernNetworking.sendToServer((class_2960)USE_ABILITY, (class_2487)new class_2487());
    }

    public static void handleWalkersSyncPacket(ModernNetworking.Context context, class_2487 packetData) {
        UUID uuid = class_4844.method_26276((int[])((int[])packetData.method_10561("uuid").orElseThrow()));
        String id = (String)packetData.method_10558("type").orElseThrow();
        class_2487 entityNbt = (class_2487)packetData.method_10562("entity_tag").orElseThrow();
        ClientNetworking.runOrQueue(context, player -> {
            @Nullable class_1657 syncTarget = player.method_37908().method_18470(uuid);
            if (syncTarget != null) {
                PlayerDataProvider data = (PlayerDataProvider)syncTarget;
                if (id.equals("minecraft:empty")) {
                    data.walkers$setCurrentShape(null);
                    syncTarget.method_18382();
                    return;
                }
                entityNbt.method_10582("id", id);
                class_11368 in = class_11352.method_71417((class_8942)Walkers.PROBLEM_REPORTER, (class_7225.class_7874)player.method_56673(), (class_2487)entityNbt);
                Optional type = class_1299.method_17684((class_11368)in);
                if (type.isPresent()) {
                    class_1309 shape = data.walkers$getCurrentShape();
                    if (shape == null || !((class_1299)type.get()).equals(shape.method_5864())) {
                        shape = (class_1309)((class_1299)type.get()).method_5883(syncTarget.method_37908(), class_3730.field_52444);
                        data.walkers$setCurrentShape(shape);
                        syncTarget.method_18382();
                    }
                    if (shape != null) {
                        shape.method_5651(in);
                    }
                }
            }
        });
    }

    public static void handleAbilitySyncPacket(ModernNetworking.Context context, class_2487 packet) {
        int cooldown = (Integer)packet.method_10550("cooldown").orElseThrow();
        ClientNetworking.runOrQueue(context, player -> ((PlayerDataProvider)player).walkers$setAbilityCooldown(cooldown));
    }
}

