/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.ability.impl.specific;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.ShapeAbility;

public class TurtleAbility<T extends LivingEntity>
extends ShapeAbility<T> {
    public static final ResourceLocation ID = Walkers.id("turtle");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onUse(Player player, LivingEntity shape, Level world) {
        if (!player.isInWater() && CEntity.isOnGround((Entity)player) && world.getBlockState(player.blockPosition()).isAir()) {
            BlockState turtlEggBlockstate = (BlockState)Blocks.TURTLE_EGG.defaultBlockState().setValue((Property)TurtleEggBlock.EGGS, (Comparable)Integer.valueOf(player.getRandom().nextInt(4) + 1));
            world.setBlock(player.blockPosition(), turtlEggBlockstate, 3);
            world.playSound(null, player.blockPosition(), SoundEvents.TURTLE_LAY_EGG, SoundSource.BLOCKS, 0.3f, 0.9f + world.random.nextFloat() * 0.2f);
        }
    }

    @Override
    public Item getIcon() {
        return Items.TURTLE_EGG;
    }

    @Override
    public int getDefaultCooldown() {
        return 6000;
    }
}

