/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import tocraft.craftedcore.event.Event;
import tocraft.craftedcore.event.EventFactory;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;

@FunctionalInterface
public interface FlightHelper {
    public static final Event<FlightHelper> GRANT = EventFactory.createWithInteractionResult((Object[])new FlightHelper[0]);
    public static final Event<FlightHelper> REVOKE = EventFactory.createWithInteractionResult((Object[])new FlightHelper[0]);

    public InteractionResult event(ServerPlayer var1);

    public static void grantFlightTo(ServerPlayer player) {
        if (!((FlightHelper)GRANT.invoke()).event(player).consumesAction()) {
            player.getAbilities().mayfly = true;
        }
    }

    public static boolean hasFlight(ServerPlayer player) {
        return player.getAbilities().mayfly;
    }

    public static void updateFlyingSpeed(Player player) {
        player.getAbilities().setFlyingSpeed(PlayerShape.getCurrentShape(player) != null ? Walkers.CONFIG.flySpeed : 0.05f);
    }

    public static void revokeFlight(ServerPlayer player) {
        if (!((FlightHelper)REVOKE.invoke()).event(player).consumesAction()) {
            if (player.gameMode.isSurvival()) {
                player.getAbilities().mayfly = false;
            }
            player.getAbilities().flying = false;
        }
    }
}

