/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.data.variants;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public record AdvancedNBTEntries(List<CompoundTag> variantData) {
    public static final Codec<AdvancedNBTEntries> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)CompoundTag.CODEC).fieldOf("variants").forGetter(o -> {
        HashMap<String, CompoundTag> map = new HashMap<String, CompoundTag>();
        for (int i = 0; i < o.variantData().size(); ++i) {
            map.put(String.valueOf(i), o.variantData().get(i));
        }
        return map;
    })).apply((Applicative)instance, instance.stable(variantDataMap -> {
        ArrayList<CompoundTag> variantData = new ArrayList<CompoundTag>();
        variantDataMap.entrySet().stream().sorted(Comparator.comparingInt(entry -> Integer.parseInt((String)entry.getKey()))).forEach(entry -> variantData.add((CompoundTag)entry.getValue()));
        return new AdvancedNBTEntries(variantData);
    })));

    public int getData(CompoundTag tag) {
        for (CompoundTag compoundTag : this.variantData()) {
            boolean bool = true;
            for (String key : compoundTag.getAllKeys()) {
                if (!tag.contains(key) || tag.get(key) != compoundTag.get(key)) {
                    bool = false;
                }
                if (bool) continue;
                break;
            }
            if (!bool) continue;
            return this.variantData().indexOf(compoundTag);
        }
        return -1;
    }

    public void fromData(CompoundTag tag, int data) {
        if (data < this.variantData().size()) {
            for (String key : this.variantData().get(data).getAllKeys()) {
                Tag value = this.variantData().get(data).get(key);
                if (value == null) continue;
                tag.put(key, value);
            }
        }
    }

    public int highestId() {
        return this.variantData().size() - 1;
    }
}

