/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.data.variants;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.data.variants.NBTTypeProvider;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;

public class TypeProviderDataManager
extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).create();
    public static Codec<Either<TypeProviderEntry<?>, String>> TYPE_PROVIDER_LIST_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("entity_type").forGetter(o -> ((TypeProviderEntry)o.left().orElseThrow()).entityTypeKey()), (App)Codec.STRING.optionalFieldOf("required_mod", (Object)"").forGetter(o -> {
        String requiredMod = ((TypeProviderEntry)o.left().orElseThrow()).requiredMod();
        if (requiredMod == null) {
            return "";
        }
        return requiredMod;
    }), (App)ResourceLocation.CODEC.optionalFieldOf("parent").forGetter(o -> {
        for (Pair<EntityType<? extends LivingEntity>, TypeProvider<?>> pair : TypeProviderRegistry.getAll()) {
            if (pair.getSecond() != ((TypeProviderEntry)o.left().orElseThrow()).typeProvider()) continue;
            return Optional.of(EntityType.getKey((EntityType)((EntityType)pair.getFirst())));
        }
        return Optional.empty();
    }), (App)Codec.STRING.optionalFieldOf("type_provider_class").forGetter(o -> {
        if (((TypeProviderEntry)o.left().orElseThrow()).typeProvider() instanceof NBTTypeProvider) {
            return Optional.empty();
        }
        return Optional.of(((TypeProviderEntry)o.left().orElseThrow()).typeProvider().getClass().getName());
    }), (App)NBTTypeProvider.CODEC.optionalFieldOf("type_provider").forGetter(o -> {
        TypeProvider patt0$temp = ((TypeProviderEntry)o.left().orElseThrow()).typeProvider();
        if (patt0$temp instanceof NBTTypeProvider) {
            NBTTypeProvider nbtTypeProvider = (NBTTypeProvider)patt0$temp;
            return Optional.of(nbtTypeProvider);
        }
        return Optional.empty();
    })).apply((Applicative)instance, instance.stable((entityType, requiredMod, parent, typeProviderClassOptional, typeProviderOptional) -> {
        TypeProvider typeProvider;
        if (typeProviderOptional.isPresent()) {
            typeProvider = (TypeProvider)typeProviderOptional.get();
        } else if (parent.isPresent()) {
            typeProvider = TypeProviderRegistry.getProvider((EntityType)Walkers.getEntityTypeRegistry().get((ResourceLocation)parent.get()));
        } else if (typeProviderClassOptional.isPresent()) {
            try {
                typeProvider = Class.forName((String)typeProviderClassOptional.get()).asSubclass(TypeProvider.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                return Either.right((Object)(TypeProviderDataManager.class.getSimpleName() + ": No valid type provider class registered in %s"));
            }
        } else {
            return Either.right((Object)(TypeProviderDataManager.class.getSimpleName() + ": No valid type provider registered in %s"));
        }
        if (typeProvider != null) {
            return Either.left(new TypeProviderEntry((ResourceLocation)entityType, (String)requiredMod, typeProvider));
        }
        return Either.right((Object)(TypeProviderDataManager.class.getSimpleName() + ": Error while loading %s"));
    })));

    public TypeProviderDataManager() {
        super(GSON, "walkers/variants");
    }

    protected void onApply(Map<ResourceLocation, JsonElement> map) {
        TypeProviderRegistry.clearAll();
        TypeProviderRegistry.registerDefault();
        for (Map.Entry<ResourceLocation, JsonElement> mapEntry : map.entrySet()) {
            TypeProviderEntry typeProviderEntry;
            EntityType entityType;
            Either<TypeProviderEntry<?>, String> typeProviderEntryStringEither = TypeProviderDataManager.typeProviderFromJson(mapEntry.getValue().getAsJsonObject());
            if (typeProviderEntryStringEither.right().isPresent()) {
                Walkers.LOGGER.warn(String.format((String)typeProviderEntryStringEither.right().get(), mapEntry.getKey()));
                continue;
            }
            if (!typeProviderEntryStringEither.left().isPresent() || (entityType = (typeProviderEntry = (TypeProviderEntry)typeProviderEntryStringEither.left().get()).entityType()) == null) continue;
            TypeProviderRegistry.register(entityType, typeProviderEntry.typeProvider());
            Walkers.LOGGER.info("{}: {} registered for {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), typeProviderEntry.entityTypeKey(), typeProviderEntry.typeProvider().getClass()});
        }
    }

    private static Either<TypeProviderEntry<?>, String> typeProviderFromJson(JsonObject json) {
        return (Either)TYPE_PROVIDER_LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(JsonParseException::new);
    }

    public record TypeProviderEntry<L extends LivingEntity>(ResourceLocation entityTypeKey, @Nullable String requiredMod, TypeProvider<L> typeProvider) {
        public TypeProviderEntry(EntityType<L> entityType, String requiredMod, TypeProvider<L> typeProvider) {
            this(EntityType.getKey(entityType), requiredMod, typeProvider);
        }

        @Nullable
        public EntityType<L> entityType() {
            if ((this.requiredMod() == null || this.requiredMod().isBlank() || PlatformData.isModLoaded((String)this.requiredMod())) && Walkers.getEntityTypeRegistry().containsKey(this.entityTypeKey())) {
                return (EntityType)Walkers.getEntityTypeRegistry().get(this.entityTypeKey());
            }
            return null;
        }
    }
}

