/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.model;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.model.AllayModel;
import net.minecraft.client.model.BlazeModel;
import net.minecraft.client.model.CamelModel;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.FoxModel;
import net.minecraft.client.model.HoglinModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.model.LlamaModel;
import net.minecraft.client.model.OcelotModel;
import net.minecraft.client.model.PandaModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.PolarBearModel;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.RavagerModel;
import net.minecraft.client.model.SpiderModel;
import net.minecraft.client.model.SquidModel;
import net.minecraft.client.model.StriderModel;
import net.minecraft.client.model.VexModel;
import net.minecraft.client.model.WardenModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import tocraft.craftedcore.util.Maths;
import tocraft.walkers.api.model.ArmRenderingManipulator;
import tocraft.walkers.api.model.ClassArmProvider;
import tocraft.walkers.api.model.EntityArmProvider;
import tocraft.walkers.api.model.impl.GenericEntityArm;
import tocraft.walkers.mixin.client.accessor.BlazeEntityModelAccessor;
import tocraft.walkers.mixin.client.accessor.IllagerEntityModelAccessor;
import tocraft.walkers.mixin.client.accessor.LlamaEntityModelAccessor;
import tocraft.walkers.mixin.client.accessor.OcelotEntityModelAccessor;
import tocraft.walkers.mixin.client.accessor.QuadrupedEntityModelAccessor;
import tocraft.walkers.mixin.client.accessor.RavagerEntityModelAccessor;
import tocraft.walkers.mixin.client.accessor.SpiderEntityModelAccessor;
import tocraft.walkers.mixin.client.accessor.SquidEntityModelAccessor;

@OnlyIn(value=Dist.CLIENT)
public class EntityArms {
    private static final Map<EntityType<? extends LivingEntity>, Tuple<EntityArmProvider<? extends LivingEntity>, ArmRenderingManipulator<?>>> DIRECT_PROVIDERS = new LinkedHashMap();
    private static final Map<Class<?>, Tuple<ClassArmProvider<?>, ArmRenderingManipulator<?>>> CLASS_PROVIDERS = new LinkedHashMap();

    public static <T extends LivingEntity> void register(EntityType<T> type, EntityArmProvider<T> provider) {
        EntityArms.register(type, provider, (PoseStack stack, EntityModel<T> model) -> {});
    }

    public static <T extends LivingEntity> void register(EntityType<T> type, EntityArmProvider<T> provider, ArmRenderingManipulator<EntityModel<T>> manipulator) {
        DIRECT_PROVIDERS.put(type, new Tuple(provider, manipulator));
    }

    public static <T extends EntityModel<?>> void register(Class<T> modelClass, ClassArmProvider<T> provider) {
        EntityArms.register(modelClass, provider, (PoseStack stack, T model) -> {});
    }

    public static <T extends EntityModel<?>> void register(Class<T> modelClass, ClassArmProvider<T> provider, ArmRenderingManipulator<T> manipulator) {
        CLASS_PROVIDERS.put(modelClass, new Tuple(provider, manipulator));
    }

    @Nullable
    public static <T extends LivingEntity> Tuple<ModelPart, ArmRenderingManipulator<?>> get(T entity, EntityModel<T> model) {
        Tuple<EntityArmProvider<? extends LivingEntity>, ArmRenderingManipulator<?>> before = DIRECT_PROVIDERS.get(entity.getType());
        if (before != null) {
            Tuple provider = new Tuple((Object)((EntityArmProvider)before.getA()), (Object)((ArmRenderingManipulator)before.getB()));
            return new Tuple((Object)((EntityArmProvider)provider.getA()).getArm(entity, model), (Object)((ArmRenderingManipulator)provider.getB()));
        }
        Optional<Tuple> beforeClassProvider = CLASS_PROVIDERS.entrySet().stream().filter(pair -> ((Class)pair.getKey()).isInstance(model)).findFirst().map(entry -> new Tuple((Object)((ClassArmProvider)((Tuple)entry.getValue()).getA()), (Object)((ArmRenderingManipulator)((Tuple)entry.getValue()).getB())));
        if (beforeClassProvider.isPresent()) {
            Tuple classProvider = new Tuple((Object)((ClassArmProvider)beforeClassProvider.get().getA()), (Object)((ArmRenderingManipulator)beforeClassProvider.get().getB()));
            return new Tuple((Object)((ClassArmProvider)classProvider.getA()).getArm(entity, model), (Object)((ArmRenderingManipulator)classProvider.getB()));
        }
        return null;
    }

    @Nullable
    public static <T extends LivingEntity> EntityArmProvider<T> get(EntityType<LivingEntity> type) {
        return (EntityArmProvider)DIRECT_PROVIDERS.get(type);
    }

    @Nullable
    public static <T extends LivingEntity> EntityArmProvider<T> get(Class<EntityModel<? extends LivingEntity>> modelClass) {
        return (EntityArmProvider)CLASS_PROVIDERS.get(modelClass);
    }

    public static void init() {
        EntityArms.register(LlamaModel.class, (LivingEntity llama, T model) -> ((LlamaEntityModelAccessor)model).getRightFrontLeg());
        EntityArms.register(PandaModel.class, (LivingEntity panda, T model) -> ((QuadrupedEntityModelAccessor)model).getRightFrontLeg(), (PoseStack stack, T model) -> stack.translate(0.0, -0.5, 0.0));
        EntityArms.register(BlazeModel.class, (LivingEntity blaze, T model) -> ((BlazeEntityModelAccessor)model).getUpperBodyParts()[10], (PoseStack stack, T model) -> {
            stack.mulPose(Maths.getDegreesQuaternion((Vector3f)Maths.POSITIVE_Z(), (float)45.0f));
            stack.mulPose(Maths.getDegreesQuaternion((Vector3f)Maths.POSITIVE_Y(), (float)-15.0f));
            stack.mulPose(Maths.getDegreesQuaternion((Vector3f)Maths.POSITIVE_X(), (float)-25.0f));
            stack.translate(0.0, 0.0, -0.25);
        });
        EntityArms.register(OcelotModel.class, (LivingEntity ocelot, T model) -> ((OcelotEntityModelAccessor)model).getRightFrontLeg());
        EntityArms.register(SpiderModel.class, (LivingEntity spider, T model) -> ((SpiderEntityModelAccessor)model).getRightFrontLeg(), (PoseStack stack, T model) -> {
            stack.mulPose(Maths.getDegreesQuaternion((Vector3f)Maths.POSITIVE_Y(), (float)-15.0f));
            stack.mulPose(Maths.getDegreesQuaternion((Vector3f)Maths.POSITIVE_X(), (float)15.0f));
            stack.translate(0.0f, 0.0f, 0.0f);
        });
        EntityArms.register(IronGolemModel.class, (LivingEntity golem, T model) -> model.getFlowerHoldingArm(), (PoseStack stack, T model) -> stack.translate(0.0, 0.0, -0.5));
        EntityArms.register(PigModel.class, (LivingEntity pig, T model) -> ((QuadrupedEntityModelAccessor)model).getRightFrontLeg(), (PoseStack stack, T model) -> stack.translate(0.0, 0.0, 0.6));
        EntityArms.register(PolarBearModel.class, (LivingEntity bear, T model) -> ((QuadrupedEntityModelAccessor)model).getRightFrontLeg(), (PoseStack stack, T model) -> stack.translate(0.0, 0.0, 0.3));
        EntityArms.register(RavagerModel.class, (LivingEntity bear, T model) -> ((RavagerEntityModelAccessor)model).getRightFrontLeg());
        EntityArms.register(SquidModel.class, (LivingEntity squid, T model) -> ((SquidEntityModelAccessor)model).getTentacles()[0]);
        EntityArms.register(HorseModel.class, new GenericEntityArm(), (PoseStack stack, T model) -> {
            stack.mulPose(Maths.getDegreesQuaternion((Vector3f)Maths.POSITIVE_Y(), (float)-15.0f));
            stack.translate(0.0, -0.25, 0.25);
        });
        EntityArms.register(CamelModel.class, new GenericEntityArm(), (PoseStack stack, T model) -> stack.translate(0.0, -0.25, 0.0));
        EntityArms.register(FoxModel.class, new GenericEntityArm(), (PoseStack stack, T model) -> stack.translate(0.0, -0.1, 0.0));
        EntityArms.register(WolfModel.class, new GenericEntityArm(), (PoseStack stack, T model) -> stack.translate(0.0, -0.1, 0.0));
        EntityArms.register(StriderModel.class, new GenericEntityArm("right_leg"));
        EntityArms.register(WardenModel.class, new GenericEntityArm("bone", "body", "right_arm"), (PoseStack stack, T model) -> {
            stack.scale(0.5f, 0.5f, 0.5f);
            stack.translate(0.0, 0.75, -1.0);
        });
        EntityArms.register(AllayModel.class, new GenericEntityArm("root", "body", "right_arm"), (PoseStack stack, T model) -> {
            stack.scale(5.0f, 5.0f, 5.0f);
            stack.translate(0.2, 0.5, -0.35);
        });
        EntityArms.register(VexModel.class, new GenericEntityArm("root", "body", "right_arm"), (PoseStack stack, T model) -> {
            stack.scale(5.0f, 5.0f, 5.0f);
            stack.translate(0.2, 0.5, -0.35);
        });
        EntityArms.register(CreeperModel.class, new GenericEntityArm(), (PoseStack stack, T model) -> stack.translate(0.0, -0.5, 0.0));
        EntityArms.register(HoglinModel.class, new GenericEntityArm(), (PoseStack stack, T model) -> stack.scale(0.75f, 0.75f, 0.75f));
        EntityArms.register(QuadrupedModel.class, (LivingEntity quad, T model) -> ((QuadrupedEntityModelAccessor)model).getRightFrontLeg());
        EntityArms.register(EntityType.PILLAGER, (T pillager, EntityModel<T> model) -> ((IllagerEntityModelAccessor)model).getRightArm(), (PoseStack stack, EntityModel<T> model) -> {
            stack.mulPose(Maths.getDegreesQuaternion((Vector3f)Maths.POSITIVE_X(), (float)-10.0f));
            stack.translate(0.0, 0.5, -0.3);
        });
    }
}

