/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.model.impl;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import tocraft.walkers.api.model.EntityUpdater;
import tocraft.walkers.mixin.accessor.SquidEntityAccessor;

@OnlyIn(value=Dist.CLIENT)
public class SquidEntityUpdater<S extends Squid>
implements EntityUpdater<S> {
    @Override
    public void update(Player player, S squid) {
        ((Squid)squid).xBodyRotO = ((Squid)squid).xBodyRot;
        ((Squid)squid).zBodyRotO = ((Squid)squid).zBodyRot;
        ((Squid)squid).oldTentacleMovement = ((Squid)squid).tentacleMovement;
        ((Squid)squid).oldTentacleAngle = ((Squid)squid).tentacleAngle;
        ((Squid)squid).tentacleMovement += 1.0f / (squid.getRandom().nextFloat() + 1.0f) * 0.2f;
        if ((double)((Squid)squid).tentacleMovement > Math.PI * 2) {
            ((Squid)squid).tentacleMovement = (float)Math.PI * 2;
        }
        if (player.isInWaterOrBubble()) {
            if (((Squid)squid).tentacleMovement < (float)Math.PI) {
                float f = ((Squid)squid).tentacleMovement / (float)Math.PI;
                ((Squid)squid).tentacleAngle = Mth.sin((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    ((SquidEntityAccessor)squid).setSpeed(1.0f);
                    ((SquidEntityAccessor)squid).setRotateSpeed(1.0f);
                } else {
                    ((SquidEntityAccessor)squid).setRotateSpeed(((SquidEntityAccessor)squid).getRotateSpeed() * 0.8f);
                }
            } else {
                ((Squid)squid).tentacleAngle = 0.0f;
                ((SquidEntityAccessor)squid).setSpeed(((SquidEntityAccessor)squid).getSpeed() * 0.9f);
                ((SquidEntityAccessor)squid).setRotateSpeed(((SquidEntityAccessor)squid).getRotateSpeed() * 0.99f);
            }
            Vec3 vec3 = player.getDeltaMovement();
            double d = vec3.horizontalDistance();
            ((Squid)squid).zBodyRot += (float)Math.PI * ((SquidEntityAccessor)squid).getRotateSpeed() * 1.5f;
            ((Squid)squid).xBodyRot += (-((float)Mth.atan2((double)d, (double)vec3.y)) * 57.295776f - ((Squid)squid).xBodyRot) * 0.1f;
        } else {
            ((Squid)squid).tentacleAngle = Mth.abs((float)Mth.sin((float)((Squid)squid).tentacleMovement)) * (float)Math.PI * 0.25f;
            ((Squid)squid).xBodyRot += (-90.0f - ((Squid)squid).xBodyRot) * 0.02f;
        }
    }
}

