/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.platform;

import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.Event;
import tocraft.craftedcore.event.EventFactory;

public enum ApiLevel {
    API_ONLY(false, false, false),
    UNLOCK_ONLY(false, false, true),
    MORPHING_ONLY(true, false, false),
    MORPHING_AND_VARIANTS_MENU_ONLY(true, true, false),
    DEFAULT(true, true, true);

    public final boolean canMorph;
    public final boolean allowVariantsMenu;
    public final boolean canUnlock;
    public static final Event<OnApiLevelChange> ON_API_LEVEL_CHANGE_EVENT;
    private static ApiLevel CURRENT_LEVEL;
    @Nullable
    private static ApiLevel CLIENT_LEVEL;

    private ApiLevel(boolean canMorph, boolean allowVariantsMenu, boolean canUnlock) {
        this.canMorph = canMorph;
        this.allowVariantsMenu = allowVariantsMenu;
        this.canUnlock = canUnlock;
    }

    public static void setApiLevel(ApiLevel apiLevel) {
        if (ApiLevel.getCurrentLevel().compareTo(apiLevel) > 0) {
            ((OnApiLevelChange)ON_API_LEVEL_CHANGE_EVENT.invoke()).onApiLevelChange(apiLevel);
        }
    }

    public static ApiLevel getCurrentLevel() {
        return CURRENT_LEVEL;
    }

    @Nullable
    public static ApiLevel getClientLevel() {
        return CLIENT_LEVEL;
    }

    static {
        ON_API_LEVEL_CHANGE_EVENT = EventFactory.createWithVoid((Object[])new OnApiLevelChange[0]);
        CURRENT_LEVEL = DEFAULT;
        CLIENT_LEVEL = null;
        ON_API_LEVEL_CHANGE_EVENT.register(apiLevel -> {
            CURRENT_LEVEL = apiLevel;
        });
    }

    @FunctionalInterface
    public static interface OnApiLevelChange {
        public void onApiLevelChange(ApiLevel var1);

        default public void setServerApiLevel(ApiLevel serverApiLevel) {
            CLIENT_LEVEL = ApiLevel.getCurrentLevel();
            this.onApiLevelChange(serverApiLevel);
        }
    }
}

