/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.impl.variant;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.level.Level;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.api.variant.TypeProvider;

public class FrogTypeProvider
extends TypeProvider<Frog> {
    private static final Map<Integer, String> PREFIX_BY_ID = ImmutableMap.builder().put((Object)0, (Object)"Temperate").put((Object)1, (Object)"Warm").put((Object)2, (Object)"Cold").build();

    @Override
    public int getVariantData(Frog entity) {
        return BuiltInRegistries.FROG_VARIANT.getId((Object)((FrogVariant)entity.getVariant().value()));
    }

    @Override
    public Frog create(EntityType<Frog> type, Level world, int data) {
        Frog frog = new Frog(type, world);
        frog.setVariant((Holder)BuiltInRegistries.FROG_VARIANT.getHolder(data).orElse(BuiltInRegistries.FROG_VARIANT.getHolderOrThrow(FrogVariant.TEMPERATE)));
        return frog;
    }

    @Override
    public int getFallbackData() {
        return 0;
    }

    @Override
    public int getRange() {
        return BuiltInRegistries.FROG_VARIANT.size() - 1;
    }

    @Override
    public Component modifyText(Frog frog, MutableComponent text) {
        int variant = this.getVariantData(frog);
        return TComponent.literal((String)(PREFIX_BY_ID.containsKey(variant) ? PREFIX_BY_ID.get(variant) + " " : "")).append((Component)text);
    }
}

