/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.impl.variant;

import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.variant.TypeProvider;

public class VillagerTypeProvider
extends TypeProvider<Villager> {
    @Override
    public int getVariantData(Villager entity) {
        return CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"villager_profession")).getId((Object)entity.getVillagerData().getProfession());
    }

    @Override
    public Villager create(EntityType<Villager> type, Level level, int data) {
        Villager villager = new Villager(type, level);
        villager.setVillagerData(villager.getVillagerData().setProfession((VillagerProfession)CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"villager_profession")).byId(data)));
        return villager;
    }

    @Override
    public Villager create(EntityType<Villager> type, Level level, int data, Player player) {
        if (player != null && Walkers.CONFIG.multiVectorVariants > 0) {
            Villager villager = new Villager(type, level);
            VillagerType villagerType = Walkers.CONFIG.multiVectorVariants == 2 ? VillagerType.byBiome((Holder)level.getBiome(player.blockPosition())) : (VillagerType)CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"villager_type")).byId(new Random().nextInt(0, CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"villager_type")).size() - 1));
            villager.setVariant(villagerType);
            villager.setVillagerData(villager.getVillagerData().setProfession((VillagerProfession)CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"villager_profession")).byId(data)));
            return villager;
        }
        return this.create(type, level, data);
    }

    @Override
    public int getFallbackData() {
        return 0;
    }

    @Override
    public int getRange() {
        return CRegistries.getRegistry((ResourceLocation)Identifier.parse((String)"villager_profession")).size() - 1;
    }

    @Override
    public Component modifyText(Villager entity, MutableComponent text) {
        return TComponent.literal((String)(this.formatTypePrefix(entity.getVillagerData().getProfession().toString()) + " ")).append((Component)text);
    }
}

