/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.integrations.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Enemy;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.integrations.AbstractIntegration;
import tocraft.walkers.mixin.accessor.EntityAccessor;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.PreyTrait;

public class GuardVillagersIntegration
extends AbstractIntegration {
    public static final String MODID = "guardvillagers";
    public static final ResourceLocation GUARD_VILLAGER_TYPE = Identifier.parse((String)"guardvillagers", (String)"guard");

    @Override
    public void registerTraits() {
        List<String> mobBlacklist = this.getMobBlackList();
        TraitRegistry.registerByPredicate(entity -> entity instanceof Enemy && mobBlacklist != null && !mobBlacklist.contains(((EntityAccessor)entity).callGetEncodeId()), new PreyTrait(List.of(hunter -> EntityType.getKey((EntityType)hunter.getType()).equals((Object)GUARD_VILLAGER_TYPE))));
    }

    @Nullable
    private List<String> getMobBlackList() {
        try {
            Class<?> configClass = Class.forName("tallestegg.guardvillagers.configuration.GuardConfig");
            Object commonConfig = configClass.getDeclaredField("COMMON").get(null);
            Field MobBlackListField = commonConfig.getClass().getDeclaredField("MobBlackList");
            Object MobBlacklist = MobBlackListField.get(commonConfig);
            Method getMobBlacklist = MobBlacklist.getClass().getDeclaredMethod("get", new Class[0]);
            return (List)getMobBlacklist.invoke(MobBlacklist, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            Walkers.LOGGER.error("{}: failed to get the mob blacklist: {}", GuardVillagersIntegration.class, (Object)e);
            return null;
        }
    }
}

