/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin;

import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.monster.piglin.PiglinBruteAi;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerHostility;
import tocraft.walkers.api.PlayerShape;

@Mixin(value={PiglinBruteAi.class})
public class PiglinBruteBrainMixin {
    @Inject(method={"getTargetIfWithinRange(Lnet/minecraft/world/entity/monster/piglin/AbstractPiglin;Lnet/minecraft/world/entity/ai/memory/MemoryModuleType;)Ljava/util/Optional;"}, at={@At(value="RETURN")}, cancellable=true)
    private static void getTargetIfWithinRange(AbstractPiglin piglinBrute, MemoryModuleType<? extends LivingEntity> memoryType, CallbackInfoReturnable<Optional<? extends LivingEntity>> cir) {
        cir.setReturnValue(piglinBrute.getBrain().getMemory(memoryType).filter(livingEntity -> {
            Player player;
            LivingEntity shape;
            if (livingEntity instanceof Player && (shape = PlayerShape.getCurrentShape(player = (Player)livingEntity)) != null) {
                if (shape instanceof AbstractPiglin) {
                    return false;
                }
                if (Walkers.CONFIG.hostilesIgnoreHostileShapedPlayer && shape instanceof Enemy && !PlayerHostility.hasHostility(player)) {
                    return false;
                }
            }
            return livingEntity.closerThan((Entity)piglinBrute, 12.0);
        }));
    }
}

