/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.player;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.mixin.LivingEntityMixin;
import tocraft.walkers.mixin.accessor.EntityAccessor;
import tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import tocraft.walkers.mixin.accessor.MobEntityAccessor;

@Mixin(value={Player.class})
public abstract class PlayerSoundMixin
extends LivingEntityMixin {
    @Unique
    private int shape_ambientSoundChance = 0;

    protected PlayerSoundMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"getHurtSound(Lnet/minecraft/world/damagesource/DamageSource;)Lnet/minecraft/sounds/SoundEvent;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getHurtSound(DamageSource source, CallbackInfoReturnable<SoundEvent> cir) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (Walkers.CONFIG.useShapeSounds && shape != null) {
            cir.setReturnValue((Object)((LivingEntityAccessor)shape).callGetHurtSound(source));
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tickAmbientSounds(CallbackInfo ci) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (!CEntity.level((Entity)this).isClientSide && Walkers.CONFIG.playAmbientSounds && shape instanceof Mob) {
            Mob mobShape = (Mob)shape;
            if (this.isAlive() && this.random.nextInt(1000) < this.shape_ambientSoundChance++) {
                this.shape_ambientSoundChance = -mobShape.getAmbientSoundInterval();
                SoundEvent sound = ((MobEntityAccessor)mobShape).callGetAmbientSound();
                if (sound != null) {
                    float volume = ((LivingEntityAccessor)mobShape).callGetSoundVolume();
                    float pitch = ((LivingEntityAccessor)mobShape).callGetVoicePitch();
                    if (Walkers.CONFIG.hearSelfAmbient) {
                        CEntity.level((Entity)this).playSound(null, this.getX(), this.getY(), this.getZ(), sound, this.getSoundSource(), volume, pitch);
                    } else {
                        CEntity.level((Entity)this).playSound((Player)this, this.getX(), this.getY(), this.getZ(), sound, this.getSoundSource(), volume, pitch);
                    }
                }
            }
        }
    }

    @Inject(method={"playStepSound(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"}, at={@At(value="HEAD")})
    private void handleStepSounds(BlockPos pos, BlockState state, CallbackInfo ci) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (shape != null) {
            ((EntityAccessor)shape).shape_callPlayStepSound(pos, state);
        }
    }

    @Inject(method={"getDeathSound()Lnet/minecraft/sounds/SoundEvent;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getDeathSound(CallbackInfoReturnable<SoundEvent> cir) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (Walkers.CONFIG.useShapeSounds && shape != null) {
            cir.setReturnValue((Object)((LivingEntityAccessor)shape).callGetDeathSound());
        }
    }

    @Inject(method={"getFallSounds()Lnet/minecraft/world/entity/LivingEntity$Fallsounds;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getFallSounds(CallbackInfoReturnable<LivingEntity.Fallsounds> cir) {
        LivingEntity shape = PlayerShape.getCurrentShape((Player)this);
        if (Walkers.CONFIG.useShapeSounds && shape != null) {
            cir.setReturnValue((Object)shape.getFallSounds());
        }
    }
}

