/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.player;

import com.mojang.authlib.GameProfile;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.FlightHelper;
import tocraft.walkers.api.PlayerShapeChanger;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin
extends Player {
    public ServerPlayerEntityMixin(Level world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"die(Lnet/minecraft/world/damagesource/DamageSource;)V"}, at={@At(value="HEAD")})
    private void revoke2ndShapeOnDeath(DamageSource source, CallbackInfo ci) {
        if (Walkers.CONFIG.revoke2ndShapeOnDeath && !this.isCreative() && !((ServerPlayer)this).isSpectator()) {
            PlayerShapeChanger.change2ndShape((ServerPlayer)this, null);
        }
    }

    @Inject(method={"initInventoryMenu()V"}, at={@At(value="HEAD")})
    private void onSpawn(CallbackInfo ci) {
        ServerPlayer player = (ServerPlayer)this;
        if (Walkers.hasFlyingPermissions(player)) {
            if (!FlightHelper.hasFlight(player)) {
                FlightHelper.grantFlightTo(player);
                FlightHelper.updateFlyingSpeed(this);
                this.onUpdateAbilities();
            }
            FlightHelper.grantFlightTo(player);
        }
    }
}

