/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.traits.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

public class AquaticTrait<E extends LivingEntity>
extends ShapeTrait<E> {
    public static final ResourceLocation ID = Walkers.id("aquatic");
    public static final MapCodec<AquaticTrait<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("is_aquatic").forGetter(o -> Optional.empty()), (App)Codec.BOOL.optionalFieldOf("isAquatic", (Object)true).forGetter(o -> o.isAquatic), (App)Codec.BOOL.optionalFieldOf("isLand", (Object)false).forGetter(o -> o.isLand)).apply((Applicative)instance, instance.stable((i, isAquatic, isLand) -> {
        if (i.isPresent()) {
            switch ((Integer)i.get()) {
                case 0: {
                    return new AquaticTrait(true, false);
                }
                case 1: {
                    return new AquaticTrait(true, true);
                }
                case 2: {
                    return new AquaticTrait(false, true);
                }
            }
        }
        return new AquaticTrait((boolean)isAquatic, (boolean)isLand);
    })));
    public final boolean isAquatic;
    public final boolean isLand;

    public AquaticTrait(boolean isAquatic, boolean isLand) {
        this.isAquatic = isAquatic;
        this.isLand = isLand;
    }

    public AquaticTrait(boolean isAquatic) {
        this(isAquatic, !isAquatic);
    }

    public AquaticTrait() {
        this(true, false);
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public TextureAtlasSprite getIcon() {
        if (this.isAquatic && !this.isLand) {
            BakedModel itemIcon = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getItemModel(Items.HEART_OF_THE_SEA);
            if (itemIcon != null) {
                return itemIcon.getParticleIcon();
            }
        } else if (this.isAquatic) {
            return Minecraft.getInstance().getMobEffectTextures().get(MobEffects.WATER_BREATHING);
        }
        return super.getIcon();
    }
}

