/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions;

import com.google.common.collect.ImmutableMap;
import com.metropolize.mtz_companions.entity.ClientCompanionEntity;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ClientCompanionManager {
    private static final HashMap<UUID, ClientCompanionEntity> COMPANIONS = new HashMap();

    public static void addCompanion(UUID uuid, ClientCompanionEntity companion) {
        COMPANIONS.put(uuid, companion);
    }

    public static void removeCompanion(UUID uuid) {
        COMPANIONS.remove(uuid);
    }

    public static Set<String> getCompanionNames() {
        return COMPANIONS.values().stream().map(companion -> companion.getNameWithId(true).getString()).collect(Collectors.toSet());
    }

    public static ImmutableMap<UUID, ClientCompanionEntity> getCompanions() {
        return ImmutableMap.copyOf(COMPANIONS);
    }

    @Nullable
    public static ClientCompanionEntity getCompanion(UUID uuid) {
        return COMPANIONS.get(uuid);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="mtz_companions", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class EventHandler {
        @SubscribeEvent
        public static void onLogOut(ClientPlayerNetworkEvent.LoggingOut event) {
            COMPANIONS.clear();
        }
    }
}

