/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions;

import com.metropolize.mtz_companions.ClientConfig;
import com.metropolize.mtz_companions.CommonConfig;
import com.metropolize.mtz_companions.MTZRegistries;
import com.metropolize.mtz_companions.ServerConfig;
import com.metropolize.mtz_companions.commands.CommandCommand;
import com.metropolize.mtz_companions.commands.CompanionArgument;
import com.metropolize.mtz_companions.commands.ExplorationFrequencyCommand;
import com.metropolize.mtz_companions.commands.GatherCommand;
import com.metropolize.mtz_companions.commands.MtzSummonCommand;
import com.metropolize.mtz_companions.commands.ReloadNpcCommand;
import com.metropolize.mtz_companions.commands.RememberPlacedCommand;
import com.metropolize.mtz_companions.commands.SetHomeCommand;
import com.metropolize.mtz_companions.commands.TetherCommand;
import com.metropolize.mtz_companions.commands.TogglePvpCommand;
import com.metropolize.mtz_companions.commands.ViewInventoryCommand;
import com.metropolize.mtz_companions.config.ConfigScreen;
import com.metropolize.mtz_companions.core.ServerCompanionManager;
import com.metropolize.mtz_companions.entity.CompanionFactory;
import com.metropolize.mtz_companions.entity.CompanionInventoryMenu;
import com.metropolize.mtz_companions.entity.RemoteCompanionInventoryMenu;
import com.metropolize.mtz_companions.entity.client.CompanionInventoryScreen;
import com.metropolize.mtz_companions.entity.client.RemoteCompanionInventoryScreen;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.entity.metropolize.MtzActivities;
import com.metropolize.mtz_companions.entity.metropolize.MtzItemConstants;
import com.metropolize.mtz_companions.entity.sensors.MtzSensors;
import com.metropolize.mtz_companions.network.server.ServerPacketHandler;
import com.metropolize.mtz_companions.utils.RecipeUtils;
import com.metropolize.mtzcharacterengine.MtzActivity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="mtz_companions")
public class MetropolizeMod {
    private static final Logger log = LogUtils.getLogger();
    public static final String MOD_ID = "mtz_companions";
    public static final String MOD_PREFIX = "mtz";
    public static final String MTZ_EXTENSION = ".mtz";
    public static final ExecutorService EXECUTOR = new ThreadPoolExecutor(4, 16, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    public static final String ASYNC_THREAD_NAME = "MtzAsyncWorker";
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"mtz_companions");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"mtz_companions");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"mtz_companions");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.f_256798_, (String)"mtz_companions");
    public static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.COMMAND_ARGUMENT_TYPES, (String)"mtz_companions");
    private static final RegistryObject<ArgumentTypeInfo<?, ?>> COMPANION_ARGUMENT = COMMAND_ARGUMENT_TYPES.register("companion_arg", () -> ArgumentTypeInfos.registerByClass(CompanionArgument.class, (ArgumentTypeInfo)new CompanionArgument.Info()));
    public static final RegistryObject<MenuType<CompanionInventoryMenu>> COMPANION_INVENTORY = MENU_TYPES.register("companion_inventory", () -> IForgeMenuType.create(CompanionInventoryMenu::new));
    public static final RegistryObject<MenuType<RemoteCompanionInventoryMenu>> REMOTE_COMPANION_INVENTORY = MENU_TYPES.register("remote_companion_inventory", () -> IForgeMenuType.create(RemoteCompanionInventoryMenu::new));
    public static final DeferredRegister<MtzActivity> ACTIVITIES = DeferredRegister.create((ResourceLocation)new ResourceLocation("activities"), (String)"mtz_companions");

    public MetropolizeMod() {
        MTZRegistries.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        ENTITIES.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        MtzSensors.SENSORS.register(modEventBus);
        MemoryModuleTypes.MEMORIES.register(modEventBus);
        COMMAND_ARGUMENT_TYPES.register(modEventBus);
        ACTIVITIES.register(modEventBus);
        ForgeRegistries.ITEMS.tags().createTagKey(MtzItemConstants.CAVE_ITEMS.f_203868_());
        ForgeRegistries.ITEMS.tags().createTagKey(MtzItemConstants.COMMON_RAW_FOOD.f_203868_());
        ForgeRegistries.ITEMS.tags().createTagKey(MtzItemConstants.COMMON_COOKED_FOOD.f_203868_());
        ForgeRegistries.ITEMS.tags().createTagKey(MtzItemConstants.COMMON_FOOD.f_203868_());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC, "mtz-companions-common.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC, "mtz-companions-client.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC, "mtz-companions-server.toml");
        MtzActivities.init();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(ServerPacketHandler::registerPackets);
        ForgeChunkManager.setForcedChunkLoadingCallback((String)MOD_ID, (level, ticketHelper) -> ticketHelper.getEntityTickets().keySet().forEach(arg_0 -> ((ForgeChunkManager.TicketHelper)ticketHelper).removeAllTickets(arg_0)));
    }

    @Mod.EventBusSubscriber(modid="mtz_companions", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            log.info("Starting client-side setup");
            event.enqueueWork(() -> {
                MenuScreens.m_96206_((MenuType)((MenuType)COMPANION_INVENTORY.get()), CompanionInventoryScreen::new);
                MenuScreens.m_96206_((MenuType)((MenuType)REMOTE_COMPANION_INVENTORY.get()), RemoteCompanionInventoryScreen::new);
                ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, screen) -> new ConfigScreen()));
            });
        }
    }

    @Mod.EventBusSubscriber(modid="mtz_companions", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.DEDICATED_SERVER})
    public static class ServerModEvents {
        @SubscribeEvent
        public static void onServerSetup(FMLDedicatedServerSetupEvent event) {
            log.info("Starting server-side setup");
        }
    }

    @Mod.EventBusSubscriber(modid="mtz_companions", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class CommonModEvents {
        @SubscribeEvent
        public static void entityModifyAttributeEvent(EntityAttributeModificationEvent event) {
            event.add(EntityType.f_20532_, Attributes.f_22277_, 32.0);
        }
    }

    @Mod.EventBusSubscriber(modid="mtz_companions", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ServerForgeEvents {
        @SubscribeEvent
        public static void onServerStarting(ServerStartingEvent event) {
            RecipeUtils.updateRecipeMap((Level)event.getServer().m_129880_(Level.f_46428_));
        }

        @SubscribeEvent
        public static void onServerStarted(ServerStartedEvent event) {
            Map<UUID, ResourceLocation> companions = ServerCompanionManager.getSavedCompanions(event.getServer().m_129783_());
            companions.forEach((uuid, location) -> new CompanionFactory.Builder((ResourceLocation)location, event.getServer().m_129783_(), (UUID)uuid).reloadFromTag().add());
        }

        @SubscribeEvent
        public static void registerServerCommands(RegisterCommandsEvent event) {
            CommandDispatcher dispatcher = event.getDispatcher();
            CommandBuildContext buildContext = event.getBuildContext();
            CommandCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
            MtzSummonCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
            ReloadNpcCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
            RememberPlacedCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
            ExplorationFrequencyCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
            SetHomeCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
            GatherCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
            ViewInventoryCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
            TogglePvpCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
            TetherCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher, buildContext);
        }
    }
}

