/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.capabilities;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoRegisterCapability
public interface IDomesticatedCapability {
    public static final Capability<IDomesticatedCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDomesticatedCapability>(){});
    public static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("mtz_companions", "domesticated");

    public void set(boolean var1);

    public void setWithExpiry(long var1, @Nullable Long var3);

    public boolean getAndUpdate(long var1);

    public CompoundTag serializeNBT();

    public void deserializeNBT(CompoundTag var1);

    public static class DomesticatedCapability
    implements IDomesticatedCapability {
        private static final int DEFAULT_EXPIRY = 6000;
        protected boolean domesticated;
        @Nullable
        protected Long expiryTime;

        @Override
        public void set(boolean domesticated) {
            this.domesticated = domesticated;
            this.expiryTime = null;
        }

        @Override
        public void setWithExpiry(long gameTime, @Nullable Long expiresIn) {
            long expiryTime;
            long l = expiryTime = expiresIn == null ? gameTime + 6000L : gameTime + expiresIn;
            if (this.domesticated && (this.expiryTime == null || this.expiryTime > expiryTime)) {
                return;
            }
            this.domesticated = true;
            this.expiryTime = expiresIn != null ? gameTime + expiresIn : gameTime + 6000L;
        }

        @Override
        public boolean getAndUpdate(long gameTime) {
            if (this.expiryTime != null && gameTime > this.expiryTime) {
                this.domesticated = false;
                this.expiryTime = null;
                return false;
            }
            return this.domesticated;
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("domesticated", this.domesticated);
            if (this.expiryTime != null) {
                tag.m_128356_("expiryTime", this.expiryTime.longValue());
            }
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag tag) {
            this.domesticated = tag.m_128471_("domesticated");
            if (tag.m_128441_("expiryTime")) {
                this.expiryTime = tag.m_128454_("expiryTime");
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final IDomesticatedCapability capability = new DomesticatedCapability();
        private final LazyOptional<IDomesticatedCapability> optionalCapability = LazyOptional.of(() -> this.capability);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return cap == CAPABILITY ? this.optionalCapability.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.capability.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.capability.deserializeNBT(nbt);
        }
    }
}

