/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.capabilities;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.core.ServerCompanionManager;
import com.mojang.datafixers.util.Either;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.AutoRegisterCapability;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoRegisterCapability
public interface IProtectedBlocksCapability {
    public static final Capability<IProtectedBlocksCapability> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IProtectedBlocksCapability>(){});
    public static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("mtz_companions", "protected_blocks");

    public static IProtectedBlocksCapability get(Level level, BlockPos pos) {
        LevelChunk chunk = level.m_46745_(pos);
        return IProtectedBlocksCapability.get((ChunkAccess)chunk);
    }

    public static IProtectedBlocksCapability get(ChunkAccess chunkAccess) {
        if (chunkAccess instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            IProtectedBlocksCapability capability = (IProtectedBlocksCapability)chunk.getCapability(CAPABILITY).orElseThrow(() -> new RuntimeException("LevelChunk missing IProtectedBlocksCapability"));
            capability.init(chunk);
            return capability;
        }
        return null;
    }

    default public void init(@NotNull LevelChunk chunk) {
    }

    public boolean isProtectedBlock(BlockPos var1, BlockState var2);

    public void setBlockPlaced(ServerLevel var1, ServerPlayer var2, MetropolizeBlockPos var3);

    public void onBlockRemoved(MetropolizeBlockPos var1);

    public void onBlockMarked(ServerLevel var1, MetropolizeBlockPos var2);

    public void onBlockUnmarked(MetropolizeBlockPos var1);

    public CompoundTag serializeNBT();

    public void deserializeNBT(CompoundTag var1);

    public static class ProtectedBlocksCapability
    implements IProtectedBlocksCapability {
        private final HashMap<MetropolizeBlockPos, Either<BlockState, CompoundTag>> playerPlacedBlocks = new HashMap();
        private final HashMap<MetropolizeBlockPos, Either<BlockState, CompoundTag>> markedBlocks = new HashMap();
        private final List<HashMap<MetropolizeBlockPos, Either<BlockState, CompoundTag>>> maps = List.of(this.playerPlacedBlocks, this.markedBlocks);
        private LevelChunk chunk;

        @Override
        public void init(@NotNull LevelChunk chunk) {
            this.chunk = chunk;
        }

        @Override
        public boolean isProtectedBlock(BlockPos blockPos, BlockState blockState) {
            assert (this.chunk != null);
            MetropolizeBlockPos mtzBlockPos = new MetropolizeBlockPos(blockPos);
            for (HashMap<MetropolizeBlockPos, Either<BlockState, CompoundTag>> map : this.maps) {
                if (!map.containsKey((Object)mtzBlockPos)) continue;
                Either<BlockState, CompoundTag> either = map.get((Object)mtzBlockPos);
                BlockState state = either.left().orElseGet(() -> NbtUtils.m_247651_((HolderGetter)this.chunk.m_62953_().m_246945_(Registries.f_256747_), (CompoundTag)((CompoundTag)either.right().orElseThrow())));
                if (either.left().isEmpty()) {
                    this.playerPlacedBlocks.put(mtzBlockPos, (Either<BlockState, CompoundTag>)Either.left((Object)state));
                }
                if (state.m_60713_(blockState.m_60734_())) {
                    return true;
                }
                map.remove((Object)mtzBlockPos);
                this.chunk.m_8092_(true);
            }
            return false;
        }

        @Override
        public void setBlockPlaced(ServerLevel level, @Nullable ServerPlayer player, MetropolizeBlockPos blockPos) {
            assert (this.chunk != null);
            boolean isIgnored = false;
            if (player != null) {
                Set<UUID> ignoredPlayers = ServerCompanionManager.getIgnoredPlayers(player);
                isIgnored = ignoredPlayers.contains(player.m_20148_());
            }
            if (!isIgnored) {
                this.playerPlacedBlocks.put(blockPos, (Either<BlockState, CompoundTag>)Either.left((Object)level.m_8055_((BlockPos)blockPos)));
                this.chunk.m_8092_(true);
            }
        }

        @Override
        public void onBlockRemoved(MetropolizeBlockPos blockPos) {
            assert (this.chunk != null);
            this.playerPlacedBlocks.remove((Object)blockPos);
            this.chunk.m_8092_(true);
        }

        @Override
        public void onBlockMarked(ServerLevel level, MetropolizeBlockPos blockPos) {
            assert (this.chunk != null);
            this.markedBlocks.put(blockPos, (Either<BlockState, CompoundTag>)Either.left((Object)level.m_8055_((BlockPos)blockPos)));
            this.chunk.m_8092_(true);
        }

        @Override
        public void onBlockUnmarked(MetropolizeBlockPos blockPos) {
            assert (this.chunk != null);
            this.markedBlocks.remove((Object)blockPos);
            this.chunk.m_8092_(true);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            ListTag placedBlocks = new ListTag();
            this.playerPlacedBlocks.forEach((pos, state) -> {
                CompoundTag entryTag = new CompoundTag();
                entryTag.m_128365_("blockPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                entryTag.m_128365_("blockState", (Tag)state.right().orElseGet(() -> NbtUtils.m_129202_((BlockState)((BlockState)state.left().orElseThrow()))));
                placedBlocks.add((Object)entryTag);
            });
            ListTag markedBlocks = new ListTag();
            this.markedBlocks.forEach((pos, state) -> {
                CompoundTag entryTag = new CompoundTag();
                entryTag.m_128365_("blockPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                entryTag.m_128365_("blockState", (Tag)state.right().orElseGet(() -> NbtUtils.m_129202_((BlockState)((BlockState)state.left().orElseThrow()))));
                markedBlocks.add((Object)entryTag);
            });
            tag.m_128365_("placedBlocks", (Tag)placedBlocks);
            tag.m_128365_("markedBlocks", (Tag)markedBlocks);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag tag) {
            ListTag placedBlocksTag = tag.m_128437_("placedBlocks", 10);
            for (Tag t : placedBlocksTag) {
                CompoundTag ct = (CompoundTag)t;
                this.playerPlacedBlocks.put(MetropolizeBlockPos.readBlockPos(ct.m_128469_("blockPos")), (Either<BlockState, CompoundTag>)Either.right((Object)ct.m_128469_("blockState")));
            }
            ListTag markedBlocksTag = tag.m_128437_("markedBlocks", 10);
            for (Tag t : markedBlocksTag) {
                CompoundTag ct = (CompoundTag)t;
                this.markedBlocks.put(MetropolizeBlockPos.readBlockPos(ct.m_128469_("blockPos")), (Either<BlockState, CompoundTag>)Either.right((Object)ct.m_128469_("blockState")));
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final IProtectedBlocksCapability capability = new ProtectedBlocksCapability();
        private final LazyOptional<IProtectedBlocksCapability> optionalCapability = LazyOptional.of(() -> this.capability);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return cap == CAPABILITY ? this.optionalCapability.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.capability.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.capability.deserializeNBT(nbt);
        }
    }
}

