/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.commands;

import com.metropolize.mtz_companions.commands.CompanionArgument;
import com.metropolize.mtz_companions.commands.CompanionCommand;
import com.metropolize.mtz_companions.commands.SuggestionProviders;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.metropolize.MtzActivities;
import com.metropolize.mtzcharacterengine.MtzActivity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;

public class CommandCommand
extends CompanionCommand {
    private static final Logger log = LogUtils.getLogger();
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.mtz_companions.failed"));
    public static final String NAME = "command_companion";
    public static final String DESCRIPTION = "command a companion to do something";
    public static final String STOP_COMMAND = "DEFAULT";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"mtz").then(Commands.m_82127_((String)NAME).then(Commands.m_82129_((String)"companion", (ArgumentType)new CompanionArgument(false)).then(Commands.m_82129_((String)"companion_command", (ArgumentType)StringArgumentType.string()).suggests(SuggestionProviders.COMPANION_ACTIVITIES).executes(CommandCommand::execute)))));
        log.info("Registered command: {}", (Object)NAME);
    }

    public static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerCompanionEntity companion = (ServerCompanionEntity)CompanionArgument.getEntity(context, "companion");
        String companionCommand = StringArgumentType.getString(context, (String)"companion_command");
        if (companionCommand.equals(STOP_COMMAND)) {
            companion.setOverrideActivity(null);
            return 1;
        }
        try {
            MtzActivity activity = MtzActivities.getActivity(companionCommand.toLowerCase());
            companion.setOverrideActivity(activity);
        }
        catch (IllegalArgumentException e) {
            throw ERROR_FAILED.create();
        }
        return 1;
    }
}

