/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.commands;

import com.google.gson.JsonObject;
import com.metropolize.mtz_companions.mixin_interfaces.MixinSharedSuggestionProvider;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public class CompanionArgument
implements ArgumentType<EntitySelector> {
    public static final SimpleCommandExceptionType ERROR_NOT_SINGLE_COMPANION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.companion.toomany"));
    public static final SimpleCommandExceptionType ERROR_ONLY_COMPANIONS_ALLOWED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.companion.entities"));
    private static final Collection<String> EXAMPLES = Arrays.asList("Talos", "@e[name=foo]", "dd12be42-52a9-4a91-a8a1-11c01849e498");
    private final boolean single;

    public CompanionArgument(boolean single) {
        this.single = single;
    }

    public static Entity getEntity(CommandContext<CommandSourceStack> ctx, String argument) throws CommandSyntaxException {
        return ((EntitySelector)ctx.getArgument(argument, EntitySelector.class)).m_121139_((CommandSourceStack)ctx.getSource());
    }

    public EntitySelector parse(StringReader reader) throws CommandSyntaxException {
        EntitySelectorParser entityselectorparser = new EntitySelectorParser(reader);
        EntitySelector entitySelector = entityselectorparser.m_121377_();
        if (entitySelector.m_121138_() > 1 && this.single) {
            reader.setCursor(0);
            throw ERROR_NOT_SINGLE_COMPANION.createWithContext((ImmutableStringReader)reader);
        }
        if (entitySelector.m_121159_() && !entitySelector.m_121162_()) {
            reader.setCursor(0);
            throw ERROR_ONLY_COMPANIONS_ALLOWED.createWithContext((ImmutableStringReader)reader);
        }
        return entitySelector;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> ctx, SuggestionsBuilder suggestionsBuilder) {
        Object source = ctx.getSource();
        if (source instanceof SharedSuggestionProvider) {
            SharedSuggestionProvider provider = (SharedSuggestionProvider)source;
            StringReader stringreader = new StringReader(suggestionsBuilder.getInput());
            stringreader.setCursor(suggestionsBuilder.getStart());
            EntitySelectorParser entitySelectorParser = new EntitySelectorParser(stringreader, ForgeHooks.canUseEntitySelectors((SharedSuggestionProvider)provider));
            try {
                entitySelectorParser.m_121377_();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return entitySelectorParser.m_121249_(suggestionsBuilder, builder -> {
                Collection<String> iterable = ((MixinSharedSuggestionProvider)provider).mtz_companions$getCompanionNames();
                SharedSuggestionProvider.m_82970_(iterable, (SuggestionsBuilder)builder);
            });
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static class Info
    implements ArgumentTypeInfo<CompanionArgument, Template> {
        public void serializeToNetwork(Template template, FriendlyByteBuf buf) {
            buf.writeBoolean(template.single);
        }

        public @NotNull Template deserializeFromNetwork(FriendlyByteBuf buf) {
            return new Template(buf.readBoolean());
        }

        public void serializeToJson(Template template, JsonObject object) {
            object.addProperty("amount", template.single ? "single" : "multiple");
        }

        public Template unpack(CompanionArgument argument) {
            return new Template(argument.single);
        }

        public final class Template
        implements ArgumentTypeInfo.Template<CompanionArgument> {
            final boolean single;

            Template(boolean single) {
                this.single = single;
            }

            public CompanionArgument instantiate(CommandBuildContext ctx) {
                return new CompanionArgument(this.single);
            }

            public ArgumentTypeInfo<CompanionArgument, ?> m_213709_() {
                return Info.this;
            }
        }
    }
}

