/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.commands;

import com.metropolize.mtz_companions.core.ServerCompanionManager;
import com.metropolize.mtz_companions.entity.behaviors.core.SetRandomizedMemories;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtzcharacterengine.MtzBrainOwner;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import org.slf4j.Logger;

public class ExplorationFrequencyCommand {
    private static final Logger log = LogUtils.getLogger();
    public static final String NAME = "exploration_frequency";
    private static final String FREQUENCY_ARG = "frequency";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"mtz").then(((LiteralArgumentBuilder)Commands.m_82127_((String)NAME).executes(ExplorationFrequencyCommand::query)).then(Commands.m_82129_((String)FREQUENCY_ARG, (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)1.0)).executes(ExplorationFrequencyCommand::set))));
        log.info("Registered command: {}", (Object)NAME);
    }

    public static int query(CommandContext<CommandSourceStack> context) {
        double frequency = ServerCompanionManager.getExplorationFrequency(((CommandSourceStack)context.getSource()).m_81372_());
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.mtz_companions.exploration_frequency", (Object[])new Object[]{frequency}), true);
        return 1;
    }

    public static int set(CommandContext<CommandSourceStack> context) {
        double frequency = DoubleArgumentType.getDouble(context, (String)FREQUENCY_ARG);
        ServerCompanionManager.setExplorationFrequency(((CommandSourceStack)context.getSource()).m_81372_(), frequency);
        ServerCompanionManager.getAllCompanions().forEach(e -> {
            BrainUtils.clearMemory((MtzBrainOwner)e, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE.get()));
            BrainUtils.setMemory((MtzBrainOwner)e, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.NEXT_EXPLORE_DELAY_TICKS.get()), (Object)SetRandomizedMemories.generateTimeUntilNextExplore((LivingEntity)e));
        });
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.mtz_companions.exploration_frequency", (Object[])new Object[]{frequency}), true);
        return 1;
    }
}

