/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.commands;

import com.metropolize.mtz_companions.commands.CompanionArgument;
import com.metropolize.mtz_companions.commands.CompanionCommand;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;

public class GatherCommand
extends CompanionCommand {
    private static final Logger log = LogUtils.getLogger();
    public static final String NAME = "gather";
    public static final String DESCRIPTION = "commands the companion to gather items";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"mtz").then(Commands.m_82127_((String)NAME).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"companion", (ArgumentType)new CompanionArgument(false)).then(Commands.m_82127_((String)"list").executes(GatherCommand::listItems))).then(Commands.m_82127_((String)"addItem").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)commandBuildContext)).executes(GatherCommand::addItem)).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(GatherCommand::addItem))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"removeItem").then(Commands.m_82127_((String)"all").executes(GatherCommand::removeAll))).then(Commands.m_82129_((String)"item", (ArgumentType)ItemArgument.m_235279_((CommandBuildContext)commandBuildContext)).executes(GatherCommand::removeItem))))));
        log.info("Registered command: {}", (Object)NAME);
    }

    public static int listItems(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerCompanionEntity companion = (ServerCompanionEntity)CompanionArgument.getEntity(context, "companion");
        HashMap<Item, Integer> itemsToGather = companion.getExplorationData().getItemsToGather();
        StringBuilder output = new StringBuilder();
        for (Map.Entry entry : itemsToGather.entrySet()) {
            output.append(String.format("%s: %s, ", ((Item)entry.getKey()).m_7626_(ItemStack.f_41583_).getString(), entry.getValue()));
        }
        if (!output.isEmpty()) {
            output.delete(output.length() - 2, output.length());
        } else {
            output.append(Component.m_237115_((String)"commands.mtz_companions.gather.empty").getString());
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)output.toString()), true);
        return 1;
    }

    public static int addItem(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int amount;
        ServerCompanionEntity companion = (ServerCompanionEntity)CompanionArgument.getEntity(context, "companion");
        Item item = ItemArgument.m_120963_(context, (String)"item").m_120979_();
        try {
            amount = IntegerArgumentType.getInteger(context, (String)"amount");
        }
        catch (IllegalArgumentException e) {
            amount = item.getMaxStackSize(ItemStack.f_41583_);
        }
        int finalAmount = amount;
        int heldAmount = companion.getInventory().getItemCounts().getOrDefault(item, 0);
        if (heldAmount >= finalAmount) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"commands.mtz_companions.gather.already_has", (Object[])new Object[]{heldAmount, item.m_7626_(ItemStack.f_41583_).getString()}));
            return 0;
        }
        companion.getExplorationData().getItemsToGather().put(item, amount);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.mtz_companions.gather.added", (Object[])new Object[]{finalAmount, item.m_7626_(ItemStack.f_41583_).getString()}), true);
        return 1;
    }

    public static int removeItem(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerCompanionEntity companion = (ServerCompanionEntity)CompanionArgument.getEntity(context, "companion");
        Item item = ItemArgument.m_120963_(context, (String)"item").m_120979_();
        if (!companion.getExplorationData().getItemsToGather().containsKey(item)) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"commands.mtz_companions.gather.not_found", (Object[])new Object[]{item.m_7626_(ItemStack.f_41583_).getString()}));
            return 0;
        }
        companion.getExplorationData().getItemsToGather().remove(item);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.mtz_companions.gather.removed", (Object[])new Object[]{item.m_7626_(ItemStack.f_41583_).getString()}), true);
        return 1;
    }

    public static int removeAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerCompanionEntity companion = (ServerCompanionEntity)CompanionArgument.getEntity(context, "companion");
        companion.getExplorationData().getItemsToGather().clear();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.mtz_companions.gather.removed_all"), true);
        return 1;
    }
}

