/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.commands;

import com.metropolize.mtz_companions.commands.SuggestionProviders;
import com.metropolize.mtz_companions.entity.CompanionFactory;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MtzSummonCommand {
    private static final SimpleCommandExceptionType ERROR_DUPLICATE_UUID = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.failed.uuid"));
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.summon.invalidPosition"));
    private static final String name = "summon";
    public static final String description = "summons a companion";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder args = (LiteralArgumentBuilder)Commands.m_82127_((String)name).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"companion", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SuggestionProviders.COMPANION_RESOURCES).executes(context -> MtzSummonCommand.createEntity((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"companion"), ((CommandSourceStack)context.getSource()).m_81371_()))).then(Commands.m_82129_((String)"pos", (ArgumentType)Vec3Argument.m_120841_()).executes(context -> MtzSummonCommand.createEntity((CommandSourceStack)context.getSource(), ResourceLocationArgument.m_107011_((CommandContext)context, (String)"companion"), Vec3Argument.m_120844_((CommandContext)context, (String)"pos")))));
        dispatcher.register(args);
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"mtz").then((ArgumentBuilder)args));
    }

    private static int createEntity(CommandSourceStack sourceStack, ResourceLocation npcLocation, Vec3 position) throws CommandSyntaxException {
        BlockPos blockpos = BlockPos.m_274446_((Position)position);
        if (!Level.m_46741_((BlockPos)blockpos)) {
            throw INVALID_POSITION.create();
        }
        ServerLevel serverlevel = sourceStack.m_81372_();
        ServerCompanionEntity entity = new CompanionFactory.Builder(npcLocation, serverlevel, null).withPosition(position).add();
        sourceStack.m_288197_(() -> Component.m_237110_((String)"commands.mtz_companions.summon.success", (Object[])new Object[]{entity.m_7755_()}), true);
        return 1;
    }
}

