/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.commands;

import com.metropolize.mtz_companions.commands.CompanionArgument;
import com.metropolize.mtz_companions.commands.CompanionCommand;
import com.metropolize.mtz_companions.commands.SuggestionProviders;
import com.metropolize.mtz_companions.entity.CompanionFactory;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.metropolize.MtzController;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class ReloadNpcCommand
extends CompanionCommand {
    private static final Logger log = LogUtils.getLogger();
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.mtz_companions.reload.failed"));
    public static final String NAME = "reload";
    public static final String DESCRIPTION = "reloads a companion's brain";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"mtz").then(Commands.m_82127_((String)NAME).then(Commands.m_82129_((String)"companion", (ArgumentType)new CompanionArgument(false)).then(Commands.m_82129_((String)"npcfile", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SuggestionProviders.COMPANION_RESOURCES).executes(ReloadNpcCommand::execute)))));
        log.info("Registered command: {}", (Object)NAME);
    }

    public static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String companionArg = StringArgumentType.getString(context, (String)"companion");
        ServerCompanionEntity companion = (ServerCompanionEntity)CompanionArgument.getEntity(context, "companion");
        ResourceLocation npcFile = ResourceLocationArgument.m_107011_(context, (String)"npcfile");
        try {
            MtzController controller = CompanionFactory.createCompanionController(npcFile);
            companion.setController(controller);
        }
        catch (IOException e) {
            throw ERROR_FAILED.create();
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.mtz_companions.reload.success", (Object[])new Object[]{companionArg}), true);
        return 1;
    }
}

