/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.commands;

import com.metropolize.mtz_companions.core.ServerCompanionManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;

public class RememberPlacedCommand {
    private static final Logger log = LogUtils.getLogger();
    private static final SimpleCommandExceptionType ERROR_NO_PLAYER = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"argument.entity.notfound.player"));
    public static final String NAME = "remember_placed";
    private static final String ENABLED_ARG = "enabled";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"mtz").then(((LiteralArgumentBuilder)Commands.m_82127_((String)NAME).executes(RememberPlacedCommand::query)).then(Commands.m_82129_((String)ENABLED_ARG, (ArgumentType)BoolArgumentType.bool()).executes(RememberPlacedCommand::set))));
        log.info("Registered command: {}", (Object)NAME);
    }

    public static int query(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player == null) {
            throw ERROR_NO_PLAYER.create();
        }
        boolean blocksAreRemembered = !ServerCompanionManager.isPlayerIgnored(player);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.mtz_companions.remember_placed", (Object[])new Object[]{blocksAreRemembered}), true);
        return 1;
    }

    public static int set(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        if (player == null) {
            throw ERROR_NO_PLAYER.create();
        }
        boolean doRemember = BoolArgumentType.getBool(context, (String)ENABLED_ARG);
        ServerCompanionManager.setIgnoredPlayer(player, !doRemember);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.mtz_companions.remember_placed", (Object[])new Object[]{doRemember}), true);
        return 1;
    }
}

