/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.commands;

import com.metropolize.mtz_companions.commands.CompanionArgument;
import com.metropolize.mtz_companions.commands.CompanionCommand;
import com.metropolize.mtz_companions.commands.SuggestionProviders;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public class ReplyToCommand
extends CompanionCommand {
    private static final Logger log = LogUtils.getLogger();
    public static final String NAME = "mtz_reply_to";
    public static final String DESCRIPTION = "reply to a companion";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)NAME).then(Commands.m_82129_((String)"companion", (ArgumentType)new CompanionArgument(true)).then(Commands.m_82129_((String)"choice", (ArgumentType)IntegerArgumentType.integer()).suggests(SuggestionProviders.DIALOGUE_CHOICE).executes(ReplyToCommand::execute))));
        log.info("Registered command: {}", (Object)NAME);
    }

    public static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean validChoice;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_230896_();
        assert (player != null);
        int choice = IntegerArgumentType.getInteger(context, (String)"choice");
        ServerCompanionEntity companion = (ServerCompanionEntity)CompanionArgument.getEntity(context, "companion");
        try {
            validChoice = companion.validateDialogueChoice(choice);
        }
        catch (NumberFormatException e) {
            validChoice = false;
        }
        if (!validChoice) {
            return 0;
        }
        companion.talk((Player)player, choice);
        return 1;
    }
}

