/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.commands;

import com.metropolize.mtz_companions.commands.CompanionArgument;
import com.metropolize.mtz_companions.commands.CompanionCommand;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class SetHomeCommand
extends CompanionCommand {
    private static final Logger log = LogUtils.getLogger();
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.mtz_companions.set_home.failed"));
    public static final String NAME = "set_home";
    public static final String DESCRIPTION = "sets the companion's home location to the player's current location";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"mtz").then(Commands.m_82127_((String)NAME).then(Commands.m_82129_((String)"companion", (ArgumentType)new CompanionArgument(false)).executes(SetHomeCommand::execute))));
        log.info("Registered command: {}", (Object)NAME);
    }

    public static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerCompanionEntity companion = (ServerCompanionEntity)CompanionArgument.getEntity(context, "companion");
        Vec3 pos = ((CommandSourceStack)context.getSource()).m_81371_();
        if (!companion.setHomePosition((ResourceKey<Level>)((CommandSourceStack)context.getSource()).m_81372_().m_46472_(), BlockPos.m_274446_((Position)pos))) {
            throw ERROR_FAILED.create();
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.mtz_companions.set_home.success", (Object[])new Object[]{companion.m_5446_(), pos.toString()}), true);
        return 1;
    }
}

