/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.commands;

import com.metropolize.mtz_companions.commands.CompanionArgument;
import com.metropolize.mtz_companions.commands.CompanionCommand;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtz_companions.navigation.UUIDEntityTracker;
import com.metropolize.mtzcharacterengine.MtzBrainOwner;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class TetherCommand
extends CompanionCommand {
    private static final Logger log = LogUtils.getLogger();
    public static final String NAME = "tether";
    public static final String DESCRIPTION = "set or a remove a companion's tether";
    public static final int DEFAULT_TETHER_DIST = 16;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"mtz").then(Commands.m_82127_((String)NAME).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"companion", (ArgumentType)new CompanionArgument(false)).executes(TetherCommand::getTether)).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(TetherCommand::tetherToEntity))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(TetherCommand::tetherToEntity)).then(Commands.m_82129_((String)"distance", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(TetherCommand::tetherToEntity)))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"location", (ArgumentType)Vec3Argument.m_120841_()).executes(TetherCommand::tetherToPos)).then(Commands.m_82129_((String)"distance", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(TetherCommand::tetherToPos)))).then(Commands.m_82127_((String)"clear").executes(TetherCommand::clear)))));
        log.info("Registered command: {}", (Object)NAME);
    }

    public static int getTether(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerCompanionEntity companion = (ServerCompanionEntity)CompanionArgument.getEntity(context, "companion");
        MtzWalkTarget tether = (MtzWalkTarget)((Object)BrainUtils.getMemory((MtzBrainOwner)companion, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.PATHFINDING_TETHER.get())));
        if (tether == null) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.mtz_companions.tether.none", (Object[])new Object[]{companion.m_5446_()}), false);
        } else {
            double closeEnoughDist = tether.getCloseEnoughDistance();
            PositionTracker positionTracker = tether.m_26420_();
            if (positionTracker instanceof UUIDEntityTracker) {
                UUIDEntityTracker uuidEntityTracker = (UUIDEntityTracker)positionTracker;
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.mtz_companions.tether.get", (Object[])new Object[]{companion.m_5446_(), uuidEntityTracker.getEntity().m_5446_(), closeEnoughDist}), false);
            } else {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.mtz_companions.tether.get", (Object[])new Object[]{companion.m_5446_(), tether.getTargetBlockPos().toString(), closeEnoughDist}), false);
            }
        }
        return 1;
    }

    private static int tetherToEntity(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerCompanionEntity companion = (ServerCompanionEntity)CompanionArgument.getEntity(context, "companion");
        Entity entity = EntityArgument.m_91452_(context, (String)"target");
        float distance = 16.0f;
        try {
            distance = FloatArgumentType.getFloat(context, (String)"distance");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Component msg = TetherCommand.tetherToEntity(companion, entity, distance);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> msg, true);
        return 1;
    }

    private static int tetherToPos(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerCompanionEntity companion = (ServerCompanionEntity)CompanionArgument.getEntity(context, "companion");
        Vec3 vec3 = Vec3Argument.m_120844_(context, (String)"location");
        float distance = 16.0f;
        try {
            distance = FloatArgumentType.getFloat(context, (String)"distance");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Component msg = TetherCommand.tetherToPos(companion, BlockPos.m_274446_((Position)vec3), distance);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> msg, true);
        return 1;
    }

    private static int clear(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerCompanionEntity companion = (ServerCompanionEntity)CompanionArgument.getEntity(context, "companion");
        Component msg = TetherCommand.clearTether(companion);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> msg, true);
        return 1;
    }

    public static Component clearTether(ServerCompanionEntity companion) {
        BrainUtils.clearMemory((MtzBrainOwner)companion, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.PATHFINDING_TETHER.get()));
        return Component.m_237110_((String)"commands.mtz_companions.tether.cleared", (Object[])new Object[]{companion.m_5446_()});
    }

    public static Component tetherToPos(ServerCompanionEntity companion, BlockPos pos, double distance) {
        MtzWalkTarget tether = new MtzWalkTarget(pos, 1.0f, distance);
        BrainUtils.setMemory((MtzBrainOwner)companion, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.PATHFINDING_TETHER.get()), (Object)((Object)tether));
        return Component.m_237110_((String)"commands.mtz_companions.tether.added", (Object[])new Object[]{companion.m_5446_(), pos.toString()});
    }

    public static Component tetherToEntity(ServerCompanionEntity companion, Entity entity, double distance) {
        MtzWalkTarget tether = new MtzWalkTarget(companion.m_284548_(), entity.m_20148_(), distance);
        BrainUtils.setMemory((MtzBrainOwner)companion, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.PATHFINDING_TETHER.get()), (Object)((Object)tether));
        return Component.m_237110_((String)"commands.mtz_companions.tether.added", (Object[])new Object[]{companion.m_5446_(), entity.m_5446_()});
    }
}

