/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.commands;

import com.metropolize.mtz_companions.commands.CompanionArgument;
import com.metropolize.mtz_companions.commands.CompanionCommand;
import com.metropolize.mtz_companions.entity.RemoteCompanionInventoryMenu;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ViewInventoryCommand
extends CompanionCommand {
    private static final Logger log = LogUtils.getLogger();
    public static final String NAME = "view_inventory";

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"mtz").then(Commands.m_82127_((String)NAME).then(Commands.m_82129_((String)"companion", (ArgumentType)new CompanionArgument(true)).executes(ViewInventoryCommand::execute))));
        log.info("Registered command: {}", (Object)NAME);
    }

    public static int execute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerCompanionEntity companion = (ServerCompanionEntity)CompanionArgument.getEntity(context, "companion");
        NetworkHooks.openScreen((ServerPlayer)((CommandSourceStack)context.getSource()).m_230896_(), (MenuProvider)new RemoteInventoryMenuProvider(companion), buf -> {
            buf.m_130077_(companion.m_20148_());
            buf.m_130072_(companion.m_7755_().getString(), 16);
        });
        return 1;
    }

    public static final class RemoteInventoryMenuProvider
    implements MenuProvider {
        private final ServerCompanionEntity companion;

        public RemoteInventoryMenuProvider(ServerCompanionEntity companion) {
            this.companion = companion;
        }

        @NotNull
        public Component m_5446_() {
            return this.companion.m_5446_();
        }

        @Nullable
        public AbstractContainerMenu m_7208_(int id, @NotNull Inventory _playerInventory, @NotNull Player player) {
            return new RemoteCompanionInventoryMenu(id, player, this.companion.getInventory(), (Player)this.companion);
        }
    }
}

