/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.core;

import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
public final class MetropolizeBlockPos
extends BlockPos {
    public MetropolizeBlockPos(int x, int y, int z) {
        super(x, y, z);
    }

    public MetropolizeBlockPos(BlockPos pos) {
        this(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static MetropolizeBlockPos readBlockPos(CompoundTag tag) {
        return new MetropolizeBlockPos(NbtUtils.m_129239_((CompoundTag)tag));
    }

    public boolean equals(Object o) {
        if (o instanceof BlockPos) {
            BlockPos pos = (BlockPos)o;
            return pos.m_123341_() == this.f_123285_ && pos.m_123342_() == this.f_123286_ && pos.m_123343_() == this.f_123289_;
        }
        return false;
    }

    public MetropolizeBlockPos above() {
        return new MetropolizeBlockPos(this.f_123285_, this.f_123286_ + 1, this.f_123289_);
    }

    public MetropolizeBlockPos above(int amt) {
        return amt == 0 ? this : new MetropolizeBlockPos(this.f_123285_, this.f_123286_ + amt, this.f_123289_);
    }

    public MetropolizeBlockPos below() {
        return new MetropolizeBlockPos(this.f_123285_, this.f_123286_ - 1, this.f_123289_);
    }

    public MetropolizeBlockPos below(int amt) {
        return amt == 0 ? this : new MetropolizeBlockPos(this.f_123285_, this.f_123286_ - amt, this.f_123289_);
    }

    public MetropolizeBlockPos relative(Direction dir) {
        Vec3i vec = dir.m_122436_();
        return new MetropolizeBlockPos(this.f_123285_ + vec.m_123341_(), this.f_123286_ + vec.m_123342_(), this.f_123289_ + vec.m_123343_());
    }

    public MetropolizeBlockPos relative(@NotNull Direction dir, int dist) {
        if (dist == 0) {
            return this;
        }
        Vec3i vec = dir.m_122436_();
        return new MetropolizeBlockPos(this.f_123285_ + vec.m_123341_() * dist, this.f_123286_ + vec.m_123342_() * dist, this.f_123289_ + vec.m_123343_() * dist);
    }

    public MetropolizeBlockPos north() {
        return new MetropolizeBlockPos(this.f_123285_, this.f_123286_, this.f_123289_ - 1);
    }

    public MetropolizeBlockPos north(int amt) {
        return amt == 0 ? this : new MetropolizeBlockPos(this.f_123285_, this.f_123286_, this.f_123289_ - amt);
    }

    public MetropolizeBlockPos south() {
        return new MetropolizeBlockPos(this.f_123285_, this.f_123286_, this.f_123289_ + 1);
    }

    public MetropolizeBlockPos south(int amt) {
        return amt == 0 ? this : new MetropolizeBlockPos(this.f_123285_, this.f_123286_, this.f_123289_ + amt);
    }

    public MetropolizeBlockPos east() {
        return new MetropolizeBlockPos(this.f_123285_ + 1, this.f_123286_, this.f_123289_);
    }

    public MetropolizeBlockPos east(int amt) {
        return amt == 0 ? this : new MetropolizeBlockPos(this.f_123285_ + amt, this.f_123286_, this.f_123289_);
    }

    public MetropolizeBlockPos west() {
        return new MetropolizeBlockPos(this.f_123285_ - 1, this.f_123286_, this.f_123289_);
    }

    public MetropolizeBlockPos west(int amt) {
        return amt == 0 ? this : new MetropolizeBlockPos(this.f_123285_ - amt, this.f_123286_, this.f_123289_);
    }

    public double distanceSq(BlockPos to) {
        double dx = (double)this.f_123285_ - (double)to.m_123341_();
        double dy = (double)this.f_123286_ - (double)to.m_123342_();
        double dz = (double)this.f_123289_ - (double)to.m_123343_();
        return dx * dx + dy * dy + dz * dz;
    }

    public double distanceTo(BlockPos to) {
        double dx = (double)this.f_123285_ - (double)to.m_123341_();
        double dy = (double)this.f_123286_ - (double)to.m_123342_();
        double dz = (double)this.f_123289_ - (double)to.m_123343_();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

