/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.core;

import com.metropolize.mtz_companions.capabilities.IProtectedBlocksCapability;
import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.network.server.ClientboundAddCompanionPacket;
import com.metropolize.mtz_companions.network.server.ClientboundRemoveCompanionPacket;
import com.metropolize.mtz_companions.network.server.ServerPacketHandler;
import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class ServerCompanionManager {
    private static final Logger log = LogUtils.getLogger();
    private static final Map<UUID, ServerCompanionEntity> COMPANION_MAP = new HashMap<UUID, ServerCompanionEntity>();

    private ServerCompanionManager() {
    }

    public static int getNewCompanionId() {
        Set usedIds = COMPANION_MAP.values().stream().map(ServerCompanionEntity::getCompanionId).collect(Collectors.toSet());
        return IntStream.iterate(0, n -> n + 1).filter(n -> !usedIds.contains(n)).findFirst().orElseThrow();
    }

    public static ServerCompanionEntity getCompanion(UUID id) {
        return COMPANION_MAP.get(id);
    }

    public static void onCompanionAdded(ServerCompanionEntity entity) {
        CompanionManagerSavedData globalData = ServerCompanionManager.getGlobalData(entity.f_8924_);
        globalData.addCompanion(entity);
        COMPANION_MAP.put(entity.m_20148_(), entity);
    }

    public static void onCompanionRemoved(ServerCompanionEntity entity, Entity.RemovalReason reason) {
        if (reason != Entity.RemovalReason.UNLOADED_WITH_PLAYER) {
            CompanionManagerSavedData globalData = ServerCompanionManager.getGlobalData(entity.f_8924_);
            globalData.removeCompanion(entity);
        }
        COMPANION_MAP.remove(entity.m_20148_());
        ServerPacketHandler.sendAll(new ClientboundRemoveCompanionPacket(entity));
    }

    public static Collection<ServerCompanionEntity> getAllCompanions() {
        return COMPANION_MAP.values();
    }

    public static Map<UUID, ResourceLocation> getSavedCompanions(ServerLevel level) {
        CompanionManagerSavedData globalData = ServerCompanionManager.getGlobalData(level.m_7654_());
        return globalData.companions;
    }

    public static Set<UUID> getIgnoredPlayers(ServerPlayer player) {
        CompanionManagerSavedData globalData = ServerCompanionManager.getGlobalData(player.f_8924_);
        return Set.copyOf(globalData.ignoredPlayerUUIDs);
    }

    public static void setIgnoredPlayer(ServerPlayer player, boolean ignored) {
        CompanionManagerSavedData globalData = ServerCompanionManager.getGlobalData(player.f_8924_);
        if (ignored) {
            globalData.ignoredPlayerUUIDs.add(player.m_20148_());
        } else {
            globalData.ignoredPlayerUUIDs.remove(player.m_20148_());
        }
        globalData.m_77762_();
    }

    public static boolean isPlayerIgnored(ServerPlayer player) {
        CompanionManagerSavedData globalData = ServerCompanionManager.getGlobalData(player.f_8924_);
        return globalData.ignoredPlayerUUIDs.contains(player.m_20148_());
    }

    public static void setPvp(ServerPlayer player, boolean enabled) {
        CompanionManagerSavedData globalData = ServerCompanionManager.getGlobalData(player.f_8924_);
        globalData.pvp = enabled;
        globalData.m_77762_();
    }

    public static boolean getPvp(ServerPlayer player) {
        CompanionManagerSavedData globalData = ServerCompanionManager.getGlobalData(player.f_8924_);
        return globalData.pvp;
    }

    public static void setExplorationFrequency(ServerLevel level, double frequency) {
        CompanionManagerSavedData globalData = ServerCompanionManager.getGlobalData(level.m_7654_());
        globalData.explorationFrequency = frequency;
        globalData.m_77762_();
    }

    public static double getExplorationFrequency(ServerLevel level) {
        return ServerCompanionManager.getGlobalData((MinecraftServer)level.m_7654_()).explorationFrequency;
    }

    private static CompanionManagerSavedData getGlobalData(MinecraftServer server) {
        return ServerCompanionManager.getLevelData(server.m_129783_());
    }

    private static CompanionManagerSavedData getLevelData(ServerLevel level) {
        return (CompanionManagerSavedData)level.m_8895_().m_164861_(t -> CompanionManagerSavedData.load(t, (LevelReader)level), CompanionManagerSavedData::new, "companionManagerData");
    }

    public static class CompanionManagerSavedData
    extends SavedData {
        private final HashMap<UUID, ResourceLocation> companions;
        private final Set<UUID> ignoredPlayerUUIDs;
        private final HashMap<BlockPos, BlockState> placedBlocks;
        private boolean pvp;
        private double explorationFrequency;

        private CompanionManagerSavedData() {
            this.companions = new HashMap();
            this.ignoredPlayerUUIDs = new HashSet<UUID>();
            this.placedBlocks = new HashMap();
            this.explorationFrequency = 0.5;
            this.pvp = false;
        }

        private CompanionManagerSavedData(HashMap<UUID, ResourceLocation> companions, Set<UUID> ignoredPlayerUUIDs, HashMap<BlockPos, BlockState> playerPlacedBlocks, boolean pvp, double explorationFrequency) {
            this.companions = companions;
            this.ignoredPlayerUUIDs = ignoredPlayerUUIDs;
            this.placedBlocks = playerPlacedBlocks;
            this.explorationFrequency = explorationFrequency;
            this.pvp = pvp;
        }

        public void addCompanion(ServerCompanionEntity companion) {
            this.companions.put(companion.m_20148_(), companion.getController().getResourceLocation());
            this.m_77762_();
        }

        public void removeCompanion(ServerCompanionEntity companion) {
            this.companions.remove(companion.m_20148_());
            this.m_77762_();
        }

        @NotNull
        public CompoundTag m_7176_(@NotNull CompoundTag tag) {
            tag.m_128379_("pvp", this.pvp);
            tag.m_128347_("explorationFrequency", this.explorationFrequency);
            ListTag companionUUIDsTag = new ListTag();
            this.companions.forEach((uuid, location) -> {
                CompoundTag entryTag = new CompoundTag();
                entryTag.m_128365_("uuid", (Tag)NbtUtils.m_129226_((UUID)uuid));
                entryTag.m_128365_("resourceLocation", (Tag)StringTag.m_129297_((String)location.toString()));
                companionUUIDsTag.add((Object)entryTag);
            });
            tag.m_128365_("companionUUIDs", (Tag)companionUUIDsTag);
            ListTag ignoredPlayersTag = new ListTag();
            this.ignoredPlayerUUIDs.forEach(uuid -> ignoredPlayersTag.add((Object)StringTag.m_129297_((String)uuid.toString())));
            tag.m_128365_("ignoredPlayerUUIDs", (Tag)ignoredPlayersTag);
            return tag;
        }

        public static CompanionManagerSavedData load(CompoundTag tag, LevelReader levelReader) {
            boolean pvp = tag.m_128441_("pvp") ? tag.m_128471_("pvp") : true;
            double explorationFrequency = tag.m_128441_("explorationFrequency") ? tag.m_128459_("explorationFrequency") : 0.5;
            ListTag companionUUIDTag = tag.m_128437_("companionUUIDs", 10);
            HashMap<UUID, ResourceLocation> companionUUIDs = new HashMap<UUID, ResourceLocation>();
            for (Tag t2 : companionUUIDTag) {
                CompoundTag ct = (CompoundTag)t2;
                companionUUIDs.put(ct.m_128342_("uuid"), new ResourceLocation(ct.m_128461_("resourceLocation")));
            }
            ListTag ignoredPlayersTag = tag.m_128437_("ignoredPlayerUUIDs", 8);
            HashSet<UUID> ignoredPlayerUUIDs = new HashSet<UUID>();
            ignoredPlayersTag.forEach(t -> ignoredPlayerUUIDs.add(UUID.fromString(t.m_7916_())));
            ListTag placedBlocksTag = tag.m_128437_("placedBlocks", 10);
            HashMap<BlockPos, BlockState> placedBlocks = new HashMap<BlockPos, BlockState>();
            for (Tag t3 : placedBlocksTag) {
                CompoundTag ct = (CompoundTag)t3;
                MetropolizeBlockPos pos = MetropolizeBlockPos.readBlockPos(ct.m_128469_("blockPos"));
                IProtectedBlocksCapability protectedBlocksCapability = IProtectedBlocksCapability.get((Level)((ServerLevel)levelReader), pos);
                if (protectedBlocksCapability == null) continue;
                protectedBlocksCapability.setBlockPlaced((ServerLevel)levelReader, null, new MetropolizeBlockPos(pos));
            }
            return new CompanionManagerSavedData(companionUUIDs, ignoredPlayerUUIDs, placedBlocks, pvp, explorationFrequency);
        }
    }

    @Mod.EventBusSubscriber(modid="mtz_companions", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class EventHandler {
        @SubscribeEvent
        public static void onEntityJoinLevelEvent(EntityJoinLevelEvent event) {
            Object object;
            if (!event.getLevel().f_46443_ && (object = event.getEntity()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)object;
                for (ServerCompanionEntity companion : COMPANION_MAP.values()) {
                    ServerPacketHandler.send((Object)new ClientboundAddCompanionPacket(companion), player);
                }
            }
        }

        @SubscribeEvent
        public static void onServerShutdown(ServerStoppingEvent event) {
            COMPANION_MAP.clear();
        }
    }
}

