/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity;

import com.metropolize.mtz_companions.ClientConfig;
import com.metropolize.mtz_companions.entity.Companion;
import com.metropolize.mtz_companions.movement.BodyRotationControl;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ClientCompanionEntity
extends RemotePlayer
implements Companion {
    private static final Logger log = LogUtils.getLogger();
    protected int companionId = -1;
    protected final BodyRotationControl bodyRotationControl = new BodyRotationControl((Player)this);
    public final boolean isTemporary;

    public ClientCompanionEntity(ClientLevel level, GameProfile profile) {
        this(level, profile, false);
    }

    public ClientCompanionEntity(ClientLevel level, GameProfile profile, boolean isTemporary) {
        super(level, profile);
        this.m_274367_(0.6f);
        int modelPartCustomization = 0;
        for (PlayerModelPart modelPart : PlayerModelPart.values()) {
            modelPartCustomization |= modelPart.m_36445_();
        }
        this.m_20088_().m_135381_(f_36089_, (Object)((byte)modelPartCustomization));
        this.isTemporary = isTemporary;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public Component m_5446_() {
        Component displayName = (Boolean)ClientConfig.SHOW_COMPANION_IDS.get() != false ? this.getNameWithId(false) : this.m_7755_();
        return PlayerTeam.m_83348_((Team)this.m_5647_(), (Component)displayName).m_130938_(style -> style.m_131144_(this.m_20190_()).m_131138_(this.m_20149_()));
    }

    public Component getNameWithId(boolean wrapQuotes) {
        MutableComponent name = this.m_7755_().m_6881_().m_130946_(":" + this.getCompanionId());
        if (wrapQuotes) {
            name = Component.m_237113_((String)"\"").m_7220_((Component)name).m_130946_("\"");
        }
        return name;
    }

    protected float m_5632_(float p_21260_, float f2) {
        this.bodyRotationControl.clientTick();
        return f2;
    }

    public boolean m_5833_() {
        return false;
    }

    public boolean m_7500_() {
        return false;
    }

    public boolean m_6147_() {
        return super.m_6147_() && !this.m_146900_().m_60713_(Blocks.f_50191_);
    }

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return InteractionResult.m_19078_((boolean)true);
    }

    public void m_6074_() {
        this.m_6668_(this.m_269291_().m_287172_());
        this.m_9236_().m_7605_((Entity)this, (byte)60);
        this.m_146850_(GameEvent.f_223707_);
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public void resetPose() {
        this.m_20124_(Pose.STANDING);
        this.f_19815_ = Player.f_36088_;
        this.m_146926_(0.0f);
    }

    public ResourceLocation m_108560_() {
        ResourceLocation location = new ResourceLocation("mtz_companions", "skins/" + this.m_7755_().getString().toLowerCase() + ".png");
        if (ResourceLocation.m_135830_((String)location.toString())) {
            return location;
        }
        return new ResourceLocation("mtz_companions", "skins/default_missing.png");
    }

    public int getCompanionId() {
        return this.companionId;
    }

    public void setCompanionId(int companionId) {
        this.companionId = companionId;
    }
}

