/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity;

import com.google.common.collect.ImmutableSet;
import com.metropolize.mtz_companions.entity.metropolize.MtzItemConstants;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CompanionContainer
extends Inventory
implements Container {
    public CompanionContainer(Player companion) {
        super(companion);
    }

    public ItemStack addItem(ItemStack itemStack) {
        super.m_36054_(itemStack);
        return itemStack;
    }

    public ItemStack m_8016_(int slotNumber) {
        ItemStack removed = ItemStack.f_41583_;
        if (slotNumber == 40) {
            if (!((ItemStack)this.f_35976_.get(0)).m_41619_()) {
                removed = (ItemStack)this.f_35976_.get(0);
                this.f_35976_.set(0, (Object)ItemStack.f_41583_);
            }
        } else if (slotNumber >= 36) {
            if (!((ItemStack)this.f_35975_.get(slotNumber - 36)).m_41619_()) {
                removed = (ItemStack)this.f_35975_.get(slotNumber - 36);
                this.f_35975_.set(slotNumber - 36, (Object)ItemStack.f_41583_);
            }
        } else {
            removed = super.m_8016_(slotNumber);
        }
        return removed;
    }

    public boolean m_7013_(int index, ItemStack itemStack) {
        return index >= 0 && index < this.m_6643_();
    }

    public boolean canFitItemStack(ItemStack itemStack) {
        ItemStack emptySlot = this.findFirstItemSlot(ItemStack::m_41619_);
        if (emptySlot != null) {
            return true;
        }
        ItemStack matchingStack = this.findFirstItemSlot(itemStack);
        if (matchingStack != null) {
            return matchingStack.m_41613_() + itemStack.m_41613_() < matchingStack.m_41741_();
        }
        return false;
    }

    @Nullable
    public ItemStack findFirstItemSlot(ItemStack item) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack containerStack = this.m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)containerStack, (ItemStack)item)) continue;
            return containerStack;
        }
        return null;
    }

    @Nullable
    public ItemStack findFirstItemSlot(Predicate<ItemStack> predicate) {
        Optional<ItemStack> itemStack = this.f_35974_.stream().filter(predicate).findFirst();
        return itemStack.orElse(null);
    }

    public int findSlotMatchingItem(Predicate<ItemStack> predicate) {
        for (int i = 0; i < this.f_35974_.size(); ++i) {
            if (!predicate.test((ItemStack)this.f_35974_.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public ItemStack findFirstItemSlot(Item item) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack containerStack = this.m_8020_(i);
            if (!containerStack.m_41720_().equals(item)) continue;
            return containerStack;
        }
        return null;
    }

    public void swapItems(int slot1, int slot2) {
        ItemStack itemStack1 = this.m_8020_(slot1);
        ItemStack itemStack2 = this.m_8020_(slot2);
        if (this.m_7013_(slot1, itemStack2) && this.m_7013_(slot2, itemStack1)) {
            this.m_6836_(slot1, itemStack2);
            this.m_6836_(slot2, itemStack1);
        }
    }

    public Map<Item, Integer> getItemCounts() {
        HashMap<Item, Integer> itemCountMap = new HashMap<Item, Integer>();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            Item item = itemStack.m_41720_();
            itemCountMap.put(item, itemCountMap.getOrDefault(item, 0) + itemStack.m_41613_());
        }
        return itemCountMap;
    }

    public ImmutableSet<ItemStack> getToolsForDrops() {
        HashSet<ItemStack> tools = new HashSet<ItemStack>();
        boolean addedNonTool = false;
        for (ItemStack itemStack : this.f_35974_) {
            if (MtzItemConstants.TOOLS_WITH_DROPS.contains(itemStack.m_41720_().getClass())) {
                tools.add(itemStack);
                continue;
            }
            if (addedNonTool || itemStack.m_41763_()) continue;
            addedNonTool = true;
            tools.add(itemStack);
        }
        return ImmutableSet.copyOf(tools);
    }

    public void organizeStacks() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            ItemStack removed = this.m_7407_(i, 64);
            ItemStack unmerged = this.addItem(removed);
            assert (unmerged.m_41619_());
        }
    }
}

