/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity;

import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.entity.metropolize.MtzItemConstants;
import com.metropolize.mtz_companions.navigation.exploration.ExplorationTree;
import com.metropolize.mtz_companions.navigation.exploration.ExplorationTreeNode;
import com.metropolize.mtzcharacterengine.MtzBrainOwner;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

public class CompanionExplorationData {
    private static final Logger log = LogUtils.getLogger();
    private static final double SAME_CAVE_DISTANCE = 10.0;
    public final UUID uuid;
    private final Set<ChunkPos> visitedChunks = new HashSet<ChunkPos>();
    private final ServerCompanionEntity entity;
    private final Set<ExplorationTree> caves = new HashSet<ExplorationTree>();
    private ExplorationTree nearbyCave = null;
    private final HashMap<Item, Integer> itemsToGather = new HashMap();

    public CompanionExplorationData(ServerCompanionEntity entity) {
        this.entity = entity;
        this.uuid = UUID.randomUUID();
    }

    public CompanionExplorationData(ServerCompanionEntity entity, UUID uuid) {
        this.entity = entity;
        this.uuid = uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        boolean isNearCave;
        List sensedCaves;
        if ((double)this.entity.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.entity.m_20183_()).m_123342_() <= this.entity.m_20186_()) {
            this.visitedChunks.add(this.entity.m_146902_());
        }
        Map<Item, Integer> itemCount = this.entity.getInventory().getItemCounts();
        Set<Map.Entry<Item, Integer>> itemsToGatherCopy = Set.copyOf(this.itemsToGather.entrySet());
        for (Map.Entry<Item, Integer> entry : itemsToGatherCopy) {
            if (itemCount.getOrDefault(entry.getKey(), 0) < entry.getValue()) continue;
            this.itemsToGather.remove(entry.getKey());
        }
        BrainUtils.setMemory((MtzBrainOwner)this.entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE_CAVE.get()), (Object)(!this.itemsToGather.isEmpty() && this.itemsToGather.keySet().stream().anyMatch(item -> item.m_7968_().m_204117_(MtzItemConstants.CAVE_ITEMS)) ? 1 : 0));
        MetropolizeBlockPos currentPos = this.entity.mtzBlockPosition();
        this.nearbyCave = this.getCaveContaining(currentPos, false);
        RegistryObject<MemoryModuleType<List<BlockPos>>> registryObject = MemoryModuleTypes.ASYNC_NEAREST_CAVES;
        synchronized (registryObject) {
            sensedCaves = (List)BrainUtils.memoryOrDefault((MtzBrainOwner)this.entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.ASYNC_NEAREST_CAVES.get()), List::of);
        }
        boolean bl = isNearCave = this.nearbyCave != null || sensedCaves.contains((Object)this.entity.mtzBlockPosition());
        if (isNearCave) {
            boolean success;
            if (this.nearbyCave == null) {
                this.nearbyCave = this.addNewTree(currentPos);
            } else if (this.nearbyCave.explores(this.entity, currentPos).isEmpty() && !(success = this.nearbyCave.tryAddNode(new ExplorationTreeNode(currentPos)))) {
                log.error("Unexpected failure adding {} to exploration tree.", (Object)currentPos);
            }
        }
    }

    public ExplorationTree addNewTree(MetropolizeBlockPos rootPos) {
        assert (this.getCaveContaining(rootPos, false) == null);
        ExplorationTree newTree = new ExplorationTree(rootPos);
        this.caves.add(newTree);
        return newTree;
    }

    public ExplorationTree getCaveContaining(MetropolizeBlockPos blockPos, boolean strict) {
        Optional<ExplorationTree> exploredCave = this.caves.stream().filter(cave -> cave.explores(this.entity, blockPos).isPresent()).findFirst();
        if (exploredCave.isPresent()) {
            return exploredCave.get();
        }
        if (strict) {
            return null;
        }
        ExplorationTree nearestCave = null;
        double nearestDistance = Double.POSITIVE_INFINITY;
        for (ExplorationTree tree : this.caves) {
            double distance;
            Optional<ExplorationTreeNode> node = tree.getNearest(blockPos);
            if (!node.isPresent() || !((distance = node.get().distanceTo(blockPos)) < nearestDistance) || !(distance < 10.0)) continue;
            nearestCave = tree;
        }
        return nearestCave;
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.m_128362_("ExplorationDataUUID", this.uuid);
        ListTag visitedChunkList = new ListTag();
        visitedChunkList.addAll(this.visitedChunks.stream().map(chunkPos -> new IntArrayTag(new int[]{chunkPos.f_45578_, chunkPos.f_45579_})).toList());
        tag.m_128365_("VisitedChunks", (Tag)visitedChunkList);
        tag.m_128356_("wantsToExplore", BrainUtils.getTimeUntilMemoryExpires((MtzBrainOwner)this.entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE.get())));
        tag.m_128356_("lastExplored", ((Long)BrainUtils.memoryOrDefault((MtzBrainOwner)this.entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.LAST_EXPLORE_TIME.get()), () -> 0L)).longValue());
        ListTag itemsToGatherList = new ListTag();
        this.itemsToGather.forEach((item, amount) -> {
            CompoundTag entryTag = new CompoundTag();
            entryTag.m_128405_("amount", amount.intValue());
            new ItemStack((ItemLike)item).m_41739_(entryTag);
            itemsToGatherList.add((Object)entryTag);
        });
        tag.m_128365_("itemsToGather", (Tag)itemsToGatherList);
    }

    public static CompanionExplorationData readAdditionalSaveData(ServerCompanionEntity entity, CompoundTag tag) {
        long lastExplored;
        long wantsToExploreTime;
        CompanionExplorationData explorationData = tag.m_128441_("ExplorationDataUUID") ? new CompanionExplorationData(entity, tag.m_128342_("ExplorationDataUUID")) : new CompanionExplorationData(entity);
        if (tag.m_128441_("VisitedChunks")) {
            ListTag visitedChunksList = tag.m_128437_("VisitedChunks", 11);
            for (Tag chunkTag : visitedChunksList) {
                IntArrayTag intChunkTag = (IntArrayTag)chunkTag;
                ChunkPos chunkPos = new ChunkPos(intChunkTag.get(0).m_7047_(), intChunkTag.get(1).m_7047_());
                explorationData.visitedChunks.add(chunkPos);
            }
        }
        if ((wantsToExploreTime = tag.m_128454_("wantsToExplore")) > 0L) {
            BrainUtils.setForgettableMemory((MtzBrainOwner)entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE.get()), (Object)true, (int)((int)wantsToExploreTime));
        }
        if ((lastExplored = tag.m_128454_("lastExplored")) >= 0L) {
            BrainUtils.setMemory((MtzBrainOwner)entity, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.LAST_EXPLORE_TIME.get()), (Object)lastExplored);
        }
        ListTag itemsToGatherList = tag.m_128437_("itemsToGather", 10);
        itemsToGatherList.forEach(t -> {
            CompoundTag cp = (CompoundTag)t;
            explorationData.itemsToGather.put(ItemStack.m_41712_((CompoundTag)cp).m_41720_(), cp.m_128451_("amount"));
        });
        return explorationData;
    }

    private String getCaveListTag() {
        return String.format("CompanionExplorationData_%s", this.uuid);
    }

    public Set<ChunkPos> getVisitedChunks() {
        return this.visitedChunks;
    }

    public Set<ExplorationTree> getCaves() {
        return this.caves;
    }

    public ExplorationTree getNearbyCave() {
        return this.nearbyCave;
    }

    public HashMap<Item, Integer> getItemsToGather() {
        return this.itemsToGather;
    }
}

