/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity;

import com.google.gson.Gson;
import com.metropolize.mtz_companions.entity.ServerCompanionEntity;
import com.metropolize.mtz_companions.entity.data.ASTCompanionNPCData;
import com.metropolize.mtz_companions.entity.data.CompanionNPCData;
import com.metropolize.mtz_companions.entity.metropolize.MtzController;
import com.metropolize.mtz_companions.utils.Obfuscator;
import com.mojang.logging.LogUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.resource.ResourcePackLoader;
import org.slf4j.Logger;

public final class CompanionFactory {
    private static final Logger log = LogUtils.getLogger();

    private CompanionFactory() {
    }

    public static String formatAsResourceLocation(String string) {
        return string.toLowerCase().replace(" ", "_");
    }

    @NonNull
    public static MtzController createCompanionController(ResourceLocation npcResource) throws IOException {
        CompanionNPCData data = CompanionFactory.getCompanionData(npcResource);
        if (data == null) {
            throw new FileNotFoundException(String.format("No companion data found at ResourceLocation %s", npcResource));
        }
        return new MtzController(npcResource, data);
    }

    public static ServerCompanionEntity addCompanionToLevel(ServerCompanionEntity companion, ServerLevel level, boolean isRespawn) {
        PlayerList playerList = level.m_7654_().m_6846_();
        playerList.m_11268_((Packet)ClientboundPlayerInfoUpdatePacket.m_247122_(List.of(companion)));
        playerList.f_11196_.add(companion);
        playerList.f_11197_.put(companion.m_20148_(), companion);
        if (isRespawn) {
            level.m_8845_((ServerPlayer)companion);
        } else {
            level.m_8834_((ServerPlayer)companion);
        }
        return companion;
    }

    public static List<ResourceLocation> getResourceLocations() {
        HashMap companions = new HashMap();
        PackResources packResources = (PackResources)ResourcePackLoader.getPackFor((String)"mtz_companions").orElseThrow();
        packResources.m_8031_(PackType.SERVER_DATA, "mtz_companions", "companions", (location, ioStream) -> companions.put(location, new Resource(packResources, ioStream, ResourceMetadata.f_244068_)));
        return companions.keySet().stream().toList();
    }

    public static CompanionNPCData getCompanionData(ResourceLocation resourceLocation) {
        if (!resourceLocation.m_135815_().startsWith("companions")) {
            resourceLocation = resourceLocation.m_247449_("companions/" + resourceLocation.m_135815_());
        }
        if (!resourceLocation.m_135815_().endsWith(".mtz")) {
            resourceLocation = resourceLocation.m_247449_(resourceLocation.m_135815_() + ".mtz");
        }
        try {
            PackResources packResources = (PackResources)ResourcePackLoader.getPackFor((String)"mtz_companions").orElseThrow();
            return CompanionFactory.loadCompanionDataFromBytes(((InputStream)packResources.m_214146_(PackType.SERVER_DATA, resourceLocation).m_247737_()).readAllBytes());
        }
        catch (Exception e) {
            log.error(e.toString());
            return null;
        }
    }

    @NonNull
    private static CompanionNPCData loadCompanionDataFromBytes(byte[] bytes) {
        Gson gson = ASTCompanionNPCData.getGson();
        Class<ASTCompanionNPCData> cls = ASTCompanionNPCData.class;
        return (CompanionNPCData)gson.fromJson(new String(Obfuscator.deobfuscate(bytes)), cls);
    }

    public static final class Builder {
        ServerCompanionEntity companion;
        ServerLevel level;

        public Builder(ResourceLocation npcResource, ServerLevel level, @Nullable UUID uuid) {
            try {
                MtzController controller = CompanionFactory.createCompanionController(npcResource);
                this.companion = uuid != null ? new ServerCompanionEntity(level.m_7654_(), level, controller, uuid) : new ServerCompanionEntity(level.m_7654_(), level, controller);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load companion controller: " + String.valueOf(e));
            }
            this.level = level;
        }

        public Builder(MtzController controller, ServerLevel level) {
            this.companion = new ServerCompanionEntity(level.m_7654_(), level, controller);
            this.level = level;
        }

        public Builder withPosition(Vec3 pos) {
            this.companion.m_20219_(pos);
            return this;
        }

        public Builder reloadFromTag() {
            this.level.m_7654_().m_6846_().m_11224_((ServerPlayer)this.companion);
            return this;
        }

        public ServerCompanionEntity add() {
            return CompanionFactory.addCompanionToLevel(this.companion, this.level, false);
        }
    }
}

