/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity;

import com.metropolize.mtz_companions.MetropolizeMod;
import com.metropolize.mtz_companions.entity.CompanionContainer;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lombok.NonNull;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;

public class CompanionInventoryMenu
extends AbstractContainerMenu {
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS;
    private static final EquipmentSlot[] EQUIP_SLOTS;
    private static final int X_START_ARMOR = 8;
    private static final int X_START_SLOTS = 98;
    private static final int X_START_SHIELD = 77;
    private static final int Y_START_COMPANION = 18;
    private static final int Y_QUICK_COMPANION = 76;
    private static final int Y_START_PLAYER = 108;
    private static final int Y_QUICK_PLAYER = 166;
    private static final int Y_SHIELD_COMPANION = 72;
    private static final int Y_SHIELD_PLAYER = 162;
    private static final int SLOT_SPACING = 18;
    private CompanionContainer container;
    private Player companion;

    public CompanionInventoryMenu(int id, Inventory playerInventory, FriendlyByteBuf bufData) {
        super((MenuType)MetropolizeMod.COMPANION_INVENTORY.get(), id);
        int companionId = bufData.getInt(0);
        Player companion = (Player)Minecraft.m_91087_().f_91073_.m_6815_(companionId);
        this.init(playerInventory, new CompanionContainer(companion), companion);
    }

    public CompanionInventoryMenu(int id, Inventory playerInventory, CompanionContainer container, Player companion) {
        super((MenuType)MetropolizeMod.COMPANION_INVENTORY.get(), id);
        this.init(playerInventory, container, companion);
    }

    private void init(final Inventory playerInventory, CompanionContainer container, final Player companion) {
        int i;
        this.container = container;
        this.companion = companion;
        container.m_5856_(playerInventory.f_35978_);
        for (i = 0; i < 4; ++i) {
            final EquipmentSlot slot = EQUIP_SLOTS[i];
            this.m_38897_(new Slot(this.container, 39 - i, 8, 18 + i * 18){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(@NotNull ItemStack itemStack) {
                    return itemStack.canEquip(slot, (Entity)companion);
                }

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)TEXTURE_EMPTY_SLOTS[slot.m_20749_()]);
                }
            });
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)this.container, i, 98 + i * 18, 76));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)this.container, j + (i + 1) * 9, 98 + j * 18, 18 + i * 18));
            }
        }
        this.m_38897_(new Slot(this.container, 40, 77, 72){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        this.m_38897_(new Slot((Container)playerInventory, 40, 77, 162){

            public void m_269060_(@NotNull ItemStack itemStack) {
                try {
                    Method method = ObfuscationReflectionHelper.findMethod(InventoryMenu.class, (String)"m_269535_", (Class[])new Class[]{Player.class, EquipmentSlot.class, ItemStack.class, ItemStack.class});
                    method.invoke(null, playerInventory.f_35978_, EquipmentSlot.OFFHAND, itemStack, this.m_7993_());
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | ObfuscationReflectionHelper.UnableToFindMethodException e) {
                    throw new RuntimeException(e);
                }
                super.m_269060_(itemStack);
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        for (i = 0; i < 4; ++i) {
            final EquipmentSlot slot = EQUIP_SLOTS[i];
            this.m_38897_(new Slot((Container)playerInventory, 39 - i, 8, 108 + i * 18){

                public void m_269060_(@NotNull ItemStack itemStack) {
                    try {
                        Method method = ObfuscationReflectionHelper.findMethod(InventoryMenu.class, (String)"m_269535_", (Class[])new Class[]{Player.class, EquipmentSlot.class, ItemStack.class, ItemStack.class});
                        method.invoke(null, playerInventory.f_35978_, slot, itemStack, this.m_7993_());
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | ObfuscationReflectionHelper.UnableToFindMethodException e) {
                        throw new RuntimeException(e);
                    }
                    super.m_269060_(itemStack);
                }

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(@NonNull ItemStack itemStack) {
                    if (itemStack == null) {
                        throw new NullPointerException("itemStack is marked non-null but is null");
                    }
                    return itemStack.canEquip(slot, (Entity)playerInventory.f_35978_);
                }

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)TEXTURE_EMPTY_SLOTS[slot.m_20749_()]);
                }
            });
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + (i + 1) * 9, 98 + j * 18, 108 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 98 + i * 18, 166));
        }
    }

    public boolean m_6875_(@NotNull Player player) {
        return this.container.m_6542_(player) && this.companion.m_6084_() && this.companion.m_20270_((Entity)player) < 8.0f;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            itemStack = slot.m_7993_().m_41777_();
            ItemStack itemStackCopy = itemStack.m_41777_();
            int inventorySize = this.container.m_6643_();
            if (slotIndex < inventorySize ? !this.m_38903_(itemStackCopy, inventorySize, this.f_38839_.size(), true) : !this.m_38903_(itemStackCopy, 0, inventorySize, false)) {
                return ItemStack.f_41583_;
            }
            if (itemStackCopy.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStack;
    }

    public void m_6877_(@NotNull Player p_39663_) {
        super.m_6877_(p_39663_);
        this.container.m_5785_(p_39663_);
    }

    public Player getCompanion() {
        return this.companion;
    }

    static {
        EQUIP_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
        try {
            TEXTURE_EMPTY_SLOTS = (ResourceLocation[])ObfuscationReflectionHelper.getPrivateValue(InventoryMenu.class, null, (String)"f_39699_");
        }
        catch (ObfuscationReflectionHelper.UnableToAccessFieldException | ObfuscationReflectionHelper.UnableToFindFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

