/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity;

import com.metropolize.mtz_companions.MetropolizeMod;
import com.metropolize.mtz_companions.entity.CompanionContainer;
import com.metropolize.mtz_companions.entity.client.ClientCompanionUtils;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;

public class RemoteCompanionInventoryMenu
extends AbstractContainerMenu {
    private static final ResourceLocation[] TEXTURE_EMPTY_SLOTS;
    private static final EquipmentSlot[] EQUIP_SLOTS;
    private static final int X_START_ARMOR = 8;
    private static final int X_START_SLOTS = 98;
    private static final int X_START_SHIELD = 77;
    private static final int Y_START_COMPANION = 18;
    private static final int Y_QUICK_COMPANION = 76;
    private static final int Y_SHIELD_COMPANION = 72;
    private static final int SLOT_SPACING = 18;
    private CompanionContainer container;
    private Player companion;

    public RemoteCompanionInventoryMenu(int id, Inventory playerInventory, FriendlyByteBuf bufData) {
        super((MenuType)MetropolizeMod.REMOTE_COMPANION_INVENTORY.get(), id);
        UUID companionUuid = bufData.m_130259_();
        String companionName = bufData.m_130136_(16);
        if (FMLEnvironment.dist != Dist.CLIENT) {
            throw new RuntimeException();
        }
        Player companion = ClientCompanionUtils.getOrCreateTemporaryCompanion(companionUuid, companionName);
        this.init(new CompanionContainer(companion), playerInventory.f_35978_, companion);
    }

    public RemoteCompanionInventoryMenu(int id, Player player, CompanionContainer container, Player companion) {
        super((MenuType)MetropolizeMod.REMOTE_COMPANION_INVENTORY.get(), id);
        this.init(container, player, companion);
    }

    private void init(CompanionContainer container, Player opener, Player companion) {
        int i;
        this.container = container;
        this.companion = companion;
        container.m_5856_(opener);
        for (i = 0; i < 4; ++i) {
            EquipmentSlot slot = EQUIP_SLOTS[i];
            this.m_38897_(new DisabledSlot(this.container, 39 - i, 8, 18 + i * 18).setBackground(InventoryMenu.f_39692_, TEXTURE_EMPTY_SLOTS[slot.m_20749_()]));
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new DisabledSlot(this.container, i, 98 + i * 18, 76));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new DisabledSlot(this.container, j + (i + 1) * 9, 98 + j * 18, 18 + i * 18));
            }
        }
        this.m_38897_(new DisabledSlot(this.container, 40, 77, 72).setBackground(InventoryMenu.f_39692_, InventoryMenu.f_39697_));
    }

    public boolean m_6875_(@NotNull Player player) {
        return !player.m_213877_() && this.companion.m_6084_();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player p_38941_, int p_38942_) {
        return ItemStack.f_41583_;
    }

    public void m_6877_(@NotNull Player p_39663_) {
        super.m_6877_(p_39663_);
        this.container.m_5785_(p_39663_);
    }

    public Player getCompanion() {
        return this.companion;
    }

    static {
        EQUIP_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
        try {
            TEXTURE_EMPTY_SLOTS = (ResourceLocation[])ObfuscationReflectionHelper.getPrivateValue(InventoryMenu.class, null, (String)"f_39699_");
        }
        catch (ObfuscationReflectionHelper.UnableToAccessFieldException | ObfuscationReflectionHelper.UnableToFindFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class DisabledSlot
    extends Slot {
        public DisabledSlot(Container p_40223_, int p_40224_, int p_40225_, int p_40226_) {
            super(p_40223_, p_40224_, p_40225_, p_40226_);
        }

        public boolean m_5857_(@NotNull ItemStack itemStack) {
            return false;
        }

        public boolean m_8010_(@NotNull Player player) {
            return false;
        }

        public boolean m_280329_() {
            return false;
        }
    }
}

