/*
 * Decompiled with CFR 0.152.
 */
package com.metropolize.mtz_companions.entity;

import com.metropolize.mtz_companions.DevConfig;
import com.metropolize.mtz_companions.MTZRegistries;
import com.metropolize.mtz_companions.ServerConfig;
import com.metropolize.mtz_companions.core.MetropolizeBlockPos;
import com.metropolize.mtz_companions.core.ServerCompanionManager;
import com.metropolize.mtz_companions.entity.Companion;
import com.metropolize.mtz_companions.entity.CompanionContainer;
import com.metropolize.mtz_companions.entity.CompanionExplorationData;
import com.metropolize.mtz_companions.entity.CompanionFactory;
import com.metropolize.mtz_companions.entity.CompanionInventoryMenu;
import com.metropolize.mtz_companions.entity.behaviors.BlockProjectile;
import com.metropolize.mtz_companions.entity.behaviors.core.EquipArmor;
import com.metropolize.mtz_companions.entity.behaviors.core.EquipHandTarget;
import com.metropolize.mtz_companions.entity.behaviors.core.LookAtTarget;
import com.metropolize.mtz_companions.entity.behaviors.core.PlaceTorch;
import com.metropolize.mtz_companions.entity.behaviors.core.ReturnToTether;
import com.metropolize.mtz_companions.entity.behaviors.core.SetRandomizedMemories;
import com.metropolize.mtz_companions.entity.behaviors.core.UseMainHandItem;
import com.metropolize.mtz_companions.entity.behaviors.movement.Idle;
import com.metropolize.mtz_companions.entity.behaviors.movement.MoveAlongPath;
import com.metropolize.mtz_companions.entity.data.memories.MemoryModuleTypes;
import com.metropolize.mtz_companions.entity.metropolize.CompanionState;
import com.metropolize.mtz_companions.entity.metropolize.MtzActivities;
import com.metropolize.mtz_companions.entity.metropolize.MtzController;
import com.metropolize.mtz_companions.entity.metropolize.MtzItemConstants;
import com.metropolize.mtz_companions.entity.sensors.CaveSensor;
import com.metropolize.mtz_companions.entity.sensors.HurtBySensor;
import com.metropolize.mtz_companions.entity.sensors.NearbyBlocksSensor;
import com.metropolize.mtz_companions.entity.sensors.NearbyHostileSensor;
import com.metropolize.mtz_companions.entity.sensors.NearestBedSensor;
import com.metropolize.mtz_companions.mixin_interfaces.MixinClip;
import com.metropolize.mtz_companions.movement.BlockBreakControl;
import com.metropolize.mtz_companions.movement.BlockPlaceControl;
import com.metropolize.mtz_companions.movement.BodyRotationControl;
import com.metropolize.mtz_companions.movement.CrouchControl;
import com.metropolize.mtz_companions.movement.JumpControl;
import com.metropolize.mtz_companions.movement.LookControl;
import com.metropolize.mtz_companions.movement.SprintControl;
import com.metropolize.mtz_companions.navigation.CompanionPathfinder;
import com.metropolize.mtz_companions.navigation.MtzWalkTarget;
import com.metropolize.mtz_companions.navigation.utils.MovementUtils;
import com.metropolize.mtz_companions.network.server.ClientboundAddCompanionPacket;
import com.metropolize.mtz_companions.network.server.ClientboundCompanionRotPacket;
import com.metropolize.mtz_companions.network.server.ServerPacketHandler;
import com.metropolize.mtz_companions.utils.LootTableUtils;
import com.metropolize.mtz_companions.utils.RecipeUtils;
import com.metropolize.mtzcharacterengine.ActivityInstance;
import com.metropolize.mtzcharacterengine.MtzActivity;
import com.metropolize.mtzcharacterengine.MtzBrain;
import com.metropolize.mtzcharacterengine.MtzBrainOwner;
import com.metropolize.mtzcharacterengine.api.core.behaviour.ExtendedBehaviour;
import com.metropolize.mtzcharacterengine.api.core.sensor.ExtendedSensor;
import com.metropolize.mtzcharacterengine.api.core.sensor.custom.NearbyItemsSensor;
import com.metropolize.mtzcharacterengine.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import com.metropolize.mtzcharacterengine.api.core.sensor.vanilla.NearbyPlayersSensor;
import com.metropolize.mtzcharacterengine.util.BrainUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.NonNull;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ServerCompanionEntity
extends ServerPlayer
implements Companion,
MenuProvider,
MtzBrainOwner<ServerCompanionEntity> {
    private static final Logger log = LogUtils.getLogger();
    public static final EntityDataAccessor<Integer> COMPANION_ID = SynchedEntityData.m_135353_(ServerCompanionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final AttributeModifier SPEED_MODIFIER_USING_ITEM = new AttributeModifier("Speed modifier when using item", (double)-0.8f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    protected final CompanionContainer inventory = new CompanionContainer((Player)this);
    protected CompanionExplorationData explorationData = new CompanionExplorationData(this);
    @Nullable
    protected BlockPos homePosition;
    @Nullable
    protected ResourceKey<Level> homeDimension;
    protected MtzController controller;
    protected MtzBrain<ServerCompanionEntity> brain;
    public final HashMap<String, CompanionPathfinder> pathedBehaviorPathfinders = new HashMap();
    private Set<Item> wantedItems = new HashSet<Item>();
    private Map<Item, Integer> wantedItemsWithCount = new HashMap<Item, Integer>();
    private final Map<UUID, Integer> lastSaid = new HashMap<UUID, Integer>();
    private static final int DIALOGUE_REPEAT_DELAY = 6000;
    public static final int MAX_CRAFTING_TABLE_DISTANCE = 32;
    protected CompanionPathfinder pathFinder = new CompanionPathfinder(this);
    protected final BlockPlaceControl<ServerCompanionEntity> blockPlaceControl = new BlockPlaceControl<ServerCompanionEntity>(this);
    protected final BlockBreakControl<ServerCompanionEntity> blockBreakControl = new BlockBreakControl<ServerCompanionEntity>(this);
    protected final SprintControl<ServerCompanionEntity> sprintControl = new SprintControl<ServerCompanionEntity>(this);
    protected final JumpControl jumpControl = new JumpControl((LivingEntity)this);
    protected final CrouchControl<ServerCompanionEntity> crouchControl = new CrouchControl<ServerCompanionEntity>(this);
    protected final LookControl lookControl = new LookControl(this);
    protected final BodyRotationControl bodyRotationControl = new BodyRotationControl((Player)this);
    private boolean forceKilled = false;
    private final AIChatEventHandler aiChatEventHandler = new AIChatEventHandler();

    public ServerCompanionEntity(MinecraftServer server, ServerLevel level, MtzController controller) {
        this(server, level, controller, UUID.randomUUID());
    }

    public ServerCompanionEntity(MinecraftServer server, ServerLevel level, MtzController controller, UUID uuid) {
        super(server, level, new GameProfile(uuid, controller.getName()));
        this.m_274367_(0.6f);
        this.f_8906_ = new ServerGamePacketListenerImpl(server, new Connection(PacketFlow.SERVERBOUND), (ServerPlayer)this);
        this.setController(controller);
        this.brain = this.createBrain((LivingEntity)this);
        this.f_19804_.m_135381_(COMPANION_ID, (Object)ServerCompanionManager.getNewCompanionId());
        ServerCompanionManager.onCompanionAdded(this);
        this.aiChatEventHandler.register();
        BrainUtils.setMemory((MtzBrainOwner)this, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.LAST_EXPLORE_TIME.get()), (Object)level.m_46467_());
    }

    public List<ExtendedSensor<ServerCompanionEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyLivingEntitySensor().setRadius(32.0), new HurtBySensor(), new NearestBedSensor(), new NearbyItemsSensor().setRadius(16.0, 8.0), new NearbyPlayersSensor().setRadius(128.0), new NearbyHostileSensor(), new NearbyBlocksSensor().setScanRate(e -> 5), new CaveSensor().setScanRate(e -> 5)});
    }

    public MtzBrain<ServerCompanionEntity> getMtzBrain() {
        return this.brain;
    }

    public Brain<?> m_6274_() {
        return this.getMtzBrain();
    }

    public Set<ActivityInstance<ServerCompanionEntity>> getCoreActivities() {
        MtzActivity coreActivity = new MtzActivity("core", () -> new ExtendedBehaviour[]{new LookAtTarget(), new EquipArmor(), new EquipHandTarget(), new EquipHandTarget().offhand(), new UseMainHandItem(), new BlockProjectile(), new PlaceTorch(), new SetRandomizedMemories(), new MoveAlongPath(), new ReturnToTether(), new Idle()});
        coreActivity.stopPredicate = inst -> false;
        return Set.of(new ActivityInstance((LivingEntity)this, coreActivity).withStopPredicate(inst -> false));
    }

    public Set<ActivityInstance<ServerCompanionEntity>> getDefaultActivities() {
        return MTZRegistries.ACTIVITIES.get().getValues().stream().map(activity -> new ActivityInstance((LivingEntity)this, activity)).collect(Collectors.toSet());
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddCompanionPacket(this);
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public Vec3 mtzPosition() {
        MetropolizeBlockPos blockPos = new MetropolizeBlockPos(super.m_20183_());
        Vec3 position = this.m_20182_();
        if (MovementUtils.canStandOn((Entity)this, blockPos, this.m_9236_().m_8055_((BlockPos)blockPos))) {
            return new Vec3(position.f_82479_, (double)blockPos.above().m_123342_(), position.f_82481_);
        }
        return position;
    }

    public MetropolizeBlockPos mtzBlockPosition() {
        MetropolizeBlockPos blockPos = new MetropolizeBlockPos(super.m_20183_());
        if (MovementUtils.canStandOn((Entity)this, blockPos, this.m_9236_().m_8055_((BlockPos)blockPos))) {
            return blockPos.above();
        }
        return blockPos;
    }

    public boolean setHomePosition(ResourceKey<Level> dimension, BlockPos blockPos) {
        if (!Level.m_46741_((BlockPos)blockPos)) {
            return false;
        }
        this.homePosition = blockPos;
        this.homeDimension = dimension;
        return true;
    }

    public void setController(MtzController controller) {
        this.controller = controller;
    }

    public Component getNameWithId(boolean wrapQuotes) {
        MutableComponent name = this.m_7755_().m_6881_().m_130946_(":" + this.getCompanionId());
        if (wrapQuotes) {
            name = Component.m_237113_((String)"\"").m_7220_((Component)name).m_130946_("\"");
        }
        return name;
    }

    public int getCompanionId() {
        return (Integer)this.f_19804_.m_135370_(COMPANION_ID);
    }

    public boolean m_5833_() {
        return false;
    }

    public boolean m_7500_() {
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COMPANION_ID, (Object)-1);
    }

    public Component m_5446_() {
        Component displayName = this.getNameWithId(false);
        return PlayerTeam.m_83348_((Team)this.m_5647_(), (Component)displayName).m_130938_(style -> style.m_131144_(this.m_20190_()).m_131138_(this.m_20149_()));
    }

    public void m_6672_(InteractionHand hand) {
        super.m_6672_(hand);
        AttributeInstance moveSpeed = Objects.requireNonNull(this.m_21051_(Attributes.f_22279_));
        if (!moveSpeed.m_22109_(SPEED_MODIFIER_USING_ITEM)) {
            moveSpeed.m_22118_(SPEED_MODIFIER_USING_ITEM);
        }
    }

    protected void m_142106_(ItemStack p_143402_) {
        super.m_142106_(p_143402_);
    }

    public void m_5810_() {
        super.m_5810_();
        AttributeInstance moveSpeed = Objects.requireNonNull(this.m_21051_(Attributes.f_22279_));
        moveSpeed.m_22130_(SPEED_MODIFIER_USING_ITEM);
    }

    protected void m_6728_(LivingEntity entity) {
        if (entity instanceof Hoglin || entity instanceof Zoglin || entity instanceof Ravager) {
            super.m_6728_(entity);
        }
    }

    public boolean m_264410_() {
        return super.m_264410_() && !this.m_6117_() && this.f_20902_ > 0.0f;
    }

    protected void m_6140_() {
        float headRot = this.f_20885_;
        super.m_6140_();
        this.f_20885_ = headRot;
        this.inventory.m_36068_();
        ServerPacketHandler.sendAll(new ClientboundCompanionRotPacket(this));
    }

    public void m_8119_() {
        super.m_8119_();
        super.m_9240_();
        this.m_284548_().m_7726_().m_8385_((ServerPlayer)this);
        this.m_21203_();
        this.explorationData.tick();
        if (this.m_5803_() && !this.canContinueSleep()) {
            this.m_5796_();
        }
        this.controller.tick();
        try {
            CompanionState state = new CompanionState(this);
            Map<MemoryModuleType<?>, Object> memories = this.controller.getMemories(state);
            for (Map.Entry<MemoryModuleType<?>, Object> entry2 : memories.entrySet()) {
                BrainUtils.setMemory((MtzBrainOwner)this, entry2.getKey(), (Object)entry2.getValue());
            }
            HashSet<Item> additionalWantedItems = (HashSet<Item>)BrainUtils.getMemory((MtzBrainOwner)this, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTED_ITEMS.get()));
            if (!this.explorationData.getItemsToGather().isEmpty()) {
                if (additionalWantedItems == null) {
                    BrainUtils.setMemory((MtzBrainOwner)this, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTED_ITEMS.get()), this.explorationData.getItemsToGather().keySet());
                } else {
                    additionalWantedItems = new HashSet<Item>(additionalWantedItems);
                    additionalWantedItems.addAll(this.explorationData.getItemsToGather().keySet());
                    BrainUtils.setMemory((MtzBrainOwner)this, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTED_ITEMS.get()), additionalWantedItems);
                }
            }
            if (!this.wantedItemsWithCount.isEmpty()) {
                Map<Item, Integer> itemCounts = this.inventory.getItemCounts();
                this.wantedItemsWithCount = this.wantedItemsWithCount.entrySet().stream().filter(entry -> itemCounts.getOrDefault(entry.getKey(), 0) < (Integer)entry.getValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                additionalWantedItems.addAll(this.wantedItemsWithCount.keySet());
            }
            if (additionalWantedItems != null) {
                this.wantedItems = RecipeUtils.appendCraftingIngredients(this, additionalWantedItems);
            }
            List<MtzActivity> activities = this.controller.getActivities(state);
            this.brain.setDefaultActivities(activities);
        }
        catch (Exception e) {
            this.m_146870_();
            this.m_20194_().m_6846_().m_240416_((Component)Component.m_237110_((String)"companion.mtz_companions.error.discarded", (Object[])new Object[]{this.m_7755_()}).m_130940_(ChatFormatting.DARK_RED), false);
            log.error(e.getMessage());
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (DevConfig.PATHFINDING_OVERRIDE == null) {
            List<MtzWalkTarget> walkTargets = MtzWalkTarget.fromMemories(this);
            if (walkTargets != null) {
                this.pathFinder.setGoal(this.mtzBlockPosition(), walkTargets);
            } else {
                this.pathFinder.clear();
            }
        } else {
            this.pathFinder.setGoal(this.mtzBlockPosition(), List.of(new MtzWalkTarget(DevConfig.PATHFINDING_OVERRIDE, 1.0f, 0.0)));
        }
        this.pathFinder.tick();
        this.lookControl.tick();
        this.sprintControl.tick();
        this.crouchControl.tick();
        this.jumpControl.tick();
        this.blockPlaceControl.tick();
        this.blockBreakControl.tick();
        this.brain.m_21865_(this.m_284548_(), (LivingEntity)this);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Inventory", (Tag)this.getInventory().m_36026_(new ListTag()));
        BrainUtils.withMemory((MtzBrainOwner)this, MemoryModuleTypes.CHUNKS_TO_EXPLORE.get(), chunks -> tag.m_128405_("chunksToExplore", chunks.intValue()));
        if (this.getOverrideActivity() != null) {
            tag.m_128365_("OverrideActivity", (Tag)StringTag.m_129297_((String)this.getOverrideActivity().getName()));
            tag.m_128365_("OverrideActivityTicks", (Tag)IntTag.m_128679_((int)this.getController().getOverrideTicks()));
        }
        this.addPersistedOnDeathData(tag);
    }

    protected void addPersistedOnDeathData(CompoundTag tag) {
        this.explorationData.addAdditionalSaveData(tag);
        tag.m_128405_("CompanionId", this.getCompanionId());
        ArrayList knownBeds = (ArrayList)BrainUtils.getMemory(this.brain, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.KNOWN_BEDS.get()));
        if (knownBeds == null) {
            knownBeds = new ArrayList();
        }
        tag.m_128388_("beds", knownBeds.stream().mapToLong(BlockPos::m_121878_).toArray());
        MtzWalkTarget tether = (MtzWalkTarget)((Object)BrainUtils.getMemory((MtzBrainOwner)this, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.PATHFINDING_TETHER.get())));
        if (tether != null) {
            tag.m_128365_("tether", (Tag)tether.getTag());
        }
        if (this.homePosition != null) {
            tag.m_128356_("HomePosition", this.homePosition.m_121878_());
            ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.homeDimension.m_135782_()).resultOrPartial(arg_0 -> ((Logger)log).error(arg_0)).ifPresent(homeDimension -> tag.m_128365_("HomeDimension", homeDimension));
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.getInventory().m_36035_(tag.m_128437_("Inventory", 10));
        if (tag.m_128441_("chunksToExplore")) {
            BrainUtils.setMemory((MtzBrainOwner)this, MemoryModuleTypes.CHUNKS_TO_EXPLORE.get(), (Object)tag.m_128451_("chunksToExplore"));
        }
        if (tag.m_128441_("OverrideActivity")) {
            this.setOverrideActivity(MtzActivities.getActivity(tag.m_128461_("OverrideActivity")), tag.m_128451_("OverrideActivityTicks"));
        }
        this.readPersistedOnDeathData(tag);
    }

    protected void readPersistedOnDeathData(CompoundTag tag) {
        long[] homes;
        this.explorationData = CompanionExplorationData.readAdditionalSaveData(this, tag);
        this.f_19804_.m_135381_(COMPANION_ID, (Object)tag.m_128451_("CompanionId"));
        ArrayList<BlockPos> knownBeds = new ArrayList<BlockPos>();
        for (long home : homes = tag.m_128467_("beds")) {
            knownBeds.add(BlockPos.m_122022_((long)home));
        }
        BrainUtils.setMemory(this.brain, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.KNOWN_BEDS.get()), knownBeds);
        if (tag.m_128441_("tether")) {
            CompoundTag tetherTag = tag.m_128469_("tether");
            BrainUtils.setMemory((MtzBrainOwner)this, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.PATHFINDING_TETHER.get()), (Object)((Object)MtzWalkTarget.fromTag(this.m_284548_(), tetherTag)));
        }
        if (tag.m_128441_("HomePosition")) {
            this.homePosition = BlockPos.m_122022_((long)tag.m_128454_("HomePosition"));
            this.homeDimension = (ResourceKey)Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("HomeDimension")).result().orElseThrow();
        }
    }

    public void sendChatMessage(Component message) {
        MutableComponent component = Component.m_237113_((String)String.format("<%s> ", this.getNameWithId(false).getString())).m_7220_(message);
        ((ServerLevel)this.m_9236_()).m_7654_().m_6846_().m_240416_((Component)component, false);
        this.aiChatEventHandler.onChatMessage(new ServerChatEvent((ServerPlayer)this, message.getString(), message));
    }

    public void broadcastSystemMessage(Component message, boolean muted) {
        Component finalMessage = message;
        if (muted) {
            finalMessage = message.m_6881_().m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GRAY));
        }
        ((ServerLevel)this.m_9236_()).m_7654_().m_6846_().m_240416_(finalMessage, false);
    }

    public boolean wantsToExplore() {
        return !BrainUtils.hasMemory((MtzBrainOwner)this, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.PATHFINDING_TETHER.get())) && ((Boolean)BrainUtils.memoryOrDefault(this.getMtzBrain(), (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE.get()), () -> false) != false || !this.getExplorationData().getItemsToGather().isEmpty());
    }

    public boolean m_6147_() {
        return super.m_6147_() && !this.m_146900_().m_60713_(Blocks.f_50191_);
    }

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, buf -> buf.writeInt(this.m_19879_()));
        return InteractionResult.m_19078_((boolean)false);
    }

    public void m_6667_(DamageSource damageSource) {
        super.m_6667_(damageSource);
        if (!this.m_9236_().f_46443_) {
            this.brain.m_21933_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        }
    }

    public void m_6074_() {
        this.forceKilled = true;
        this.m_5907_();
        this.m_9236_().m_7605_((Entity)this, (byte)60);
        this.m_146850_(GameEvent.f_223707_);
        this.f_8924_.m_6846_().m_11286_((ServerPlayer)this);
        File playerDataFolder = this.f_8924_.m_6846_().f_11204_.getPlayerDataFolder();
        File file1 = new File(playerDataFolder, this.m_20149_() + ".dat");
        File file2 = new File(playerDataFolder, this.m_20149_() + ".dat_old");
        boolean success = file1.delete();
        boolean bl = success = success && file2.delete();
        if (!success) {
            log.error("Could not delete player data for {}", (Object)this.m_20149_());
        }
        ServerCompanionManager.onCompanionRemoved(this, Entity.RemovalReason.KILLED);
    }

    public void resetPose() {
        this.m_20124_(Pose.STANDING);
        this.f_19815_ = Player.f_36088_;
        this.m_146926_(0.0f);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        ServerCompanionManager.onCompanionRemoved(this, reason);
        this.aiChatEventHandler.unregister();
    }

    protected void m_146912_() {
        super.m_146912_();
        ServerCompanionManager.onCompanionAdded(this);
        this.aiChatEventHandler.register();
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ >= 20 && !this.m_213877_()) {
            Level level = this.m_9236_();
            level.m_7605_((Entity)this, (byte)60);
            CompoundTag persistedData = new CompoundTag();
            this.addPersistedOnDeathData(persistedData);
            this.f_8924_.m_6846_().m_11286_((ServerPlayer)this);
            if (!level.m_6106_().m_5466_()) {
                this.respawn(persistedData);
            }
        }
    }

    public void m_9158_(ResourceKey<Level> dimension, @Nullable BlockPos blockPos, float angle, boolean forcedRespawn, boolean sendMessage) {
        super.m_9158_(dimension, blockPos, angle, forcedRespawn, sendMessage);
        if (blockPos != null && sendMessage) {
            this.broadcastSystemMessage((Component)Component.m_237110_((String)"companion.mtz_companions.set_spawn", (Object[])new Object[]{this.m_7755_(), blockPos.m_123344_()}), false);
        }
    }

    public void m_9015_(ServerPlayer player, boolean p_9017_) {
        super.m_9015_(player, p_9017_);
        if (((Boolean)ServerConfig.FORCE_KEEP_INVENTORY.get()).booleanValue()) {
            this.getInventory().m_36006_(player.m_150109_());
            this.f_36078_ = player.f_36078_;
            this.f_36079_ = player.f_36079_;
            this.f_36080_ = player.f_36080_;
            this.m_36397_(player.m_36344_());
        }
    }

    public void respawn(CompoundTag persisted) {
        BlockPos respawnPosition = this.m_8961_();
        float respawnAngle = this.m_8962_();
        ServerLevel respawnLevel = this.f_8924_.m_129880_(this.m_8963_());
        Optional optional = respawnPosition != null ? Player.m_36130_((ServerLevel)respawnLevel, (BlockPos)respawnPosition, (float)respawnAngle, (boolean)this.m_8964_(), (boolean)false) : Optional.empty();
        ServerCompanionEntity respawnedCompanion = new ServerCompanionEntity(this.f_8924_, respawnLevel, this.controller, this.f_19820_);
        respawnedCompanion.readPersistedOnDeathData(persisted);
        respawnedCompanion.m_9015_(this, false);
        respawnedCompanion.m_20234_(this.m_19879_());
        for (String s : this.m_19880_()) {
            respawnedCompanion.m_20049_(s);
        }
        if (optional.isPresent()) {
            BlockState blockState = respawnLevel.m_8055_(respawnPosition);
            Optional respawnVec3 = Optional.empty();
            if (blockState.m_60713_(Blocks.f_50724_) && RespawnAnchorBlock.m_55850_((Level)respawnLevel)) {
                int respawnAnchorCharge = (Integer)blockState.m_61143_((Property)RespawnAnchorBlock.f_55833_);
                if (respawnAnchorCharge > 0 && (respawnVec3 = RespawnAnchorBlock.m_55839_((EntityType)EntityType.f_20532_, (CollisionGetter)respawnLevel, (BlockPos)respawnPosition)).isPresent()) {
                    respawnLevel.m_7731_(respawnPosition, (BlockState)blockState.m_61124_((Property)RespawnAnchorBlock.f_55833_, (Comparable)Integer.valueOf(respawnAnchorCharge - 1)), 3);
                    respawnLevel.m_262808_(null, (double)respawnPosition.m_123341_(), (double)respawnPosition.m_123342_(), (double)respawnPosition.m_123343_(), (Holder)SoundEvents.f_12377_, SoundSource.BLOCKS, 1.0f, 1.0f, 0L);
                }
            } else {
                respawnVec3 = blockState.getRespawnPosition(EntityType.f_20532_, (LevelReader)respawnLevel, respawnPosition, respawnAngle, null);
            }
            if (respawnVec3.isPresent()) {
                Vec3 vec3 = (Vec3)respawnVec3.get();
                float angle = respawnAngle;
                if (!blockState.m_204336_(BlockTags.f_13038_) && !blockState.m_60713_(Blocks.f_50724_)) {
                    Vec3 vec31 = Vec3.m_82539_((Vec3i)respawnPosition).m_82546_(vec3).m_82541_();
                    angle = (float)Mth.m_14175_((double)(Mth.m_14136_((double)vec31.f_82481_, (double)vec31.f_82479_) * 57.2957763671875 - 90.0));
                }
                respawnedCompanion.m_5489_(respawnLevel);
                respawnedCompanion.m_7678_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, angle, 0.0f);
                respawnedCompanion.m_9158_((ResourceKey<Level>)respawnLevel.m_46472_(), respawnPosition, angle, this.m_8964_(), false);
                if (blockState.m_204336_(BlockTags.f_13038_)) {
                    respawnedCompanion.broadcastSystemMessage((Component)Component.m_237110_((String)"companion.mtz_companions.respawn.bed", (Object[])new Object[]{respawnedCompanion.m_7755_(), vec3.toString()}), false);
                } else if (blockState.m_60713_(Blocks.f_50724_)) {
                    respawnedCompanion.broadcastSystemMessage((Component)Component.m_237110_((String)"companion.mtz_companions.respawn.anchor", (Object[])new Object[]{respawnedCompanion.m_7755_(), vec3.toString()}), false);
                }
            } else {
                respawnLevel = respawnedCompanion.m_20194_().m_129783_();
                ServerCompanionEntity.respawnAtServerSpawn(respawnedCompanion);
            }
        } else {
            respawnLevel = respawnedCompanion.m_20194_().m_129783_();
            ServerCompanionEntity.respawnAtServerSpawn(respawnedCompanion);
        }
        while (!respawnLevel.m_45786_((Entity)respawnedCompanion) && respawnedCompanion.m_20186_() < (double)respawnLevel.m_151558_()) {
            respawnedCompanion.m_6034_(respawnedCompanion.m_20185_(), respawnedCompanion.m_20186_() + 1.0, respawnedCompanion.m_20189_());
        }
        CompanionFactory.addCompanionToLevel(respawnedCompanion, respawnLevel, true);
    }

    private static void respawnAtServerSpawn(ServerCompanionEntity newEntity) {
        ServerLevel overworld = newEntity.m_20194_().m_129783_();
        newEntity.m_5489_(overworld);
        newEntity.m_146884_(overworld.m_220360_().m_252807_());
        newEntity.broadcastSystemMessage((Component)Component.m_237110_((String)"companion.mtz_companions.respawn.global", (Object[])new Object[]{newEntity.m_7755_()}), false);
    }

    @NonNull
    public ItemStack m_5584_(Level p_36185_, ItemStack p_36186_) {
        this.m_36324_().eat(p_36186_.m_41720_(), p_36186_, (LivingEntity)this);
        return super.m_5584_(p_36185_, p_36186_);
    }

    @NonNull
    public CompanionContainer getInventory() {
        return this.inventory;
    }

    @Override
    public void m_8061_(EquipmentSlot slot, ItemStack itemStack) {
        this.m_181122_(itemStack);
        int equipmentLocation = this.getInventory().m_36030_(itemStack);
        ItemStack prevItem = this.m_6844_(slot);
        if (slot == EquipmentSlot.MAINHAND) {
            this.m_238392_(slot, (ItemStack)this.inventory.f_35974_.set(this.inventory.f_35977_, (Object)itemStack), itemStack);
        } else if (slot == EquipmentSlot.OFFHAND) {
            this.m_238392_(slot, (ItemStack)this.inventory.f_35976_.set(0, (Object)itemStack), itemStack);
        } else if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
            this.inventory.m_6836_(this.inventory.m_36030_(itemStack), this.inventory.m_36052_(slot.m_20749_()));
            this.m_238392_(slot, (ItemStack)this.inventory.f_35975_.set(slot.m_20749_(), (Object)itemStack), itemStack);
        }
        if (equipmentLocation != -1) {
            this.getInventory().m_6836_(equipmentLocation, prevItem);
        }
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        if (this.inventory == null) {
            return ItemStack.f_41583_;
        }
        if (slot == EquipmentSlot.MAINHAND) {
            return this.getInventory().m_36056_();
        }
        if (slot == EquipmentSlot.OFFHAND) {
            return (ItemStack)this.getInventory().f_35976_.get(0);
        }
        return slot.m_20743_() == EquipmentSlot.Type.ARMOR ? (ItemStack)this.getInventory().f_35975_.get(slot.m_20749_()) : ItemStack.f_41583_;
    }

    public boolean m_36356_(ItemStack p_36357_) {
        return this.getInventory().m_36054_(p_36357_);
    }

    public Iterable<ItemStack> m_6168_() {
        return this.getInventory().f_35975_;
    }

    public SlotAccess m_141942_(int slot) {
        if (slot >= 0 && slot < this.getInventory().f_35974_.size()) {
            return SlotAccess.m_147292_((Container)this.getInventory(), (int)slot);
        }
        int i = slot - 200;
        return i >= 0 && i < this.f_36094_.m_6643_() ? SlotAccess.m_147292_((Container)this.f_36094_, (int)i) : super.m_141942_(slot);
    }

    public boolean m_7099_(Player player) {
        return ServerCompanionManager.getPvp((ServerPlayer)player);
    }

    public boolean isAlly(LivingEntity entity) {
        Player owner;
        OwnableEntity ownable;
        LivingEntity livingEntity;
        if (entity instanceof Player) {
            return true;
        }
        return entity instanceof OwnableEntity && (livingEntity = (ownable = (OwnableEntity)entity).m_269323_()) instanceof Player && this.isAlly((LivingEntity)(owner = (Player)livingEntity));
    }

    public int m_5639_(float p_21237_, float p_21238_) {
        return super.m_5639_(p_21237_, p_21238_);
    }

    public ItemStack m_6298_(ItemStack projectile) {
        if (!(projectile.m_41720_() instanceof ProjectileWeaponItem)) {
            return ItemStack.f_41583_;
        }
        Predicate predicate = ((ProjectileWeaponItem)projectile.m_41720_()).m_6442_();
        ItemStack itemstack = ProjectileWeaponItem.m_43010_((LivingEntity)this, (Predicate)predicate);
        if (!itemstack.m_41619_()) {
            return ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)projectile, (ItemStack)itemstack);
        }
        predicate = ((ProjectileWeaponItem)projectile.m_41720_()).m_6437_();
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack itemstack1 = this.getInventory().m_8020_(i);
            if (!predicate.test(itemstack1)) continue;
            return ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)projectile, (ItemStack)itemstack1);
        }
        return ForgeHooks.getProjectile((LivingEntity)this, (ItemStack)projectile, (ItemStack)(this.m_150110_().f_35937_ ? new ItemStack((ItemLike)Items.f_42412_) : ItemStack.f_41583_));
    }

    @NonNull
    public Set<ChunkPos> getVisitedChunks() {
        return this.explorationData.getVisitedChunks();
    }

    public boolean hasSpareBlocks() {
        return this.inventory.m_18949_(MtzItemConstants.PATHFINDING_BLOCKS);
    }

    public boolean isBlockInRange(BlockPos pos) {
        return this.canReach(pos, 0.0);
    }

    public boolean isWithinMeleeAttackRange(Entity target) {
        return this.canReach(target, 0.0);
    }

    public boolean m_142582_(Entity entity) {
        return this.hasLineOfSight(this.m_9236_(), this.m_20183_(), entity, true);
    }

    public boolean hasLineOfSight(BlockPos blockPos, boolean ignoreTransparent) {
        return this.hasLineOfSight(this.m_9236_(), this.m_20183_(), blockPos, ignoreTransparent);
    }

    public boolean hasLineOfSight(Level level, BlockPos from, BlockPos to, boolean ignoreTransparent) {
        if (from.equals((Object)to)) {
            return true;
        }
        boolean isAir = level.m_8055_(to).m_60795_();
        if (isAir) {
            Vec3 eyePos = new Vec3((double)from.m_123341_(), (double)((float)from.m_123342_() + this.m_20192_()), (double)from.m_123343_());
            return ((MixinClip)level).mtz$clip(new ClipContext(eyePos, to.m_252807_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null), ignoreTransparent).m_6662_() == HitResult.Type.MISS;
        }
        boolean hasViewableFace = false;
        for (Direction d : Direction.values()) {
            BlockPos adjacentBlock = to.m_121945_(d);
            if (level.m_8055_(adjacentBlock).m_60831_((BlockGetter)level, to)) continue;
            hasViewableFace = true;
            break;
        }
        if (!hasViewableFace) {
            return false;
        }
        Vec3 eyePos = new Vec3((double)from.m_123341_(), (double)((float)from.m_123342_() + this.m_20192_()), (double)from.m_123343_());
        for (Direction d : Direction.values()) {
            if (((MixinClip)level).mtz$clip(new ClipContext(eyePos, to.m_121945_(d.m_122424_()).m_252807_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null), ignoreTransparent).m_6662_() != HitResult.Type.MISS) continue;
            return true;
        }
        return false;
    }

    public boolean hasLineOfSight(Level level, BlockPos from, Entity entity, boolean ignoreTransparent) {
        if (level != entity.m_9236_()) {
            return false;
        }
        Vec3 eyePos = new Vec3((double)from.m_123341_(), (double)((float)from.m_123342_() + this.m_20192_()), (double)from.m_123343_());
        Vec3 targetPos = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        if (targetPos.m_82554_(eyePos) > 128.0) {
            return false;
        }
        return ((MixinClip)level).mtz$clip(new ClipContext(eyePos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this), ignoreTransparent).m_6662_() == HitResult.Type.MISS;
    }

    public Map<Item, Float> getPossibleDrops(BlockPos blockPos, BlockState blockState) {
        if (this.m_9236_() instanceof ServerLevel && this.m_20194_() != null) {
            return LootTableUtils.getAllBlockDrops(blockPos, blockState, (ServerLevel)this.m_9236_(), this.m_20194_(), this.inventory.getToolsForDrops());
        }
        return new HashMap<Item, Float>();
    }

    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        return new CompanionInventoryMenu(containerId, playerInventory, this.inventory, (Player)this);
    }

    public boolean canContinueSleep() {
        Level level = this.m_9236_();
        BlockState currentPosState = level.m_8055_(this.m_20183_());
        return this.m_5803_() && !level.m_46461_() && currentPosState.m_60734_() instanceof BedBlock;
    }

    public void m_5796_() {
        BrainUtils.setForgettableMemory((MtzBrainOwner)this, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.SLEEP_COOLING_DOWN.get()), (Object)true, (int)100);
        super.m_5796_();
    }

    public void talk(Player player, int choice) {
        if (!this.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Pair<String, String[]> dialogueAndChoices = this.controller.getDialogueAndChoices(choice);
            if (dialogueAndChoices != null) {
                this.sendDialogueAndChoicesToChat(serverPlayer, dialogueAndChoices);
            }
        }
    }

    public void talk(Player player) {
        if (!this.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Pair<String, String[]> dialogueAndChoices = this.controller.getDialogueAndChoices();
            if (dialogueAndChoices != null) {
                this.sendDialogueAndChoicesToChat(serverPlayer, dialogueAndChoices);
            }
        }
    }

    protected void sendDialogueAndChoicesToChat(ServerPlayer player, Pair<String, String[]> dialogueAndChoices) {
        String dialogueStr = this.controller.formatDialogueAndChoices(dialogueAndChoices);
        OutgoingChatMessage.Disguised message = new OutgoingChatMessage.Disguised((Component)Component.m_237113_((String)dialogueStr));
        message.m_246195_(player, true, ChatType.m_240980_((ResourceKey)ChatType.f_130598_, (Entity)this));
    }

    public String[] getChoices() {
        return this.controller.getChoices();
    }

    public String getResponse() {
        return this.controller.getResponse();
    }

    public boolean validateDialogueChoice(int choice) {
        return this.controller.validateChoice(choice);
    }

    @Nullable
    public MtzActivity getOverrideActivity() {
        return this.controller.getOverrideActivity();
    }

    public void setOverrideActivity(@Nullable MtzActivity activity) {
        this.setOverrideActivity(activity, -1);
    }

    public void setOverrideActivity(@Nullable MtzActivity activity, int durationInTicks) {
        this.controller.setOverrideActivity(null, 0);
        BrainUtils.clearMemory((MtzBrainOwner)this, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE.get()));
        if (activity == null) {
            return;
        }
        if (activity.equals(MtzActivities.EXPLORE.get())) {
            if (durationInTicks == -1) {
                BrainUtils.setMemory((MtzBrainOwner)this, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE.get()), (Object)true);
            } else {
                BrainUtils.setForgettableMemory((MtzBrainOwner)this, (MemoryModuleType)((MemoryModuleType)MemoryModuleTypes.WANTS_TO_EXPLORE.get()), (Object)true, (int)durationInTicks);
            }
        } else {
            this.controller.setOverrideActivity(activity, durationInTicks);
        }
    }

    protected void m_5907_() {
        if (!this.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) && !((Boolean)ServerConfig.FORCE_KEEP_INVENTORY.get()).booleanValue() || this.forceKilled) {
            this.m_36345_();
            this.getInventory().m_36071_();
        }
    }

    protected void m_36345_() {
        for (int i = 0; i < this.getInventory().m_6643_(); ++i) {
            ItemStack itemstack = this.getInventory().m_8020_(i);
            if (itemstack.m_41619_() || !EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.getInventory().m_8016_(i);
        }
    }

    public int m_213860_() {
        if (!(this.m_9236_().m_46469_().m_46207_(GameRules.f_46133_) || ((Boolean)ServerConfig.FORCE_KEEP_INVENTORY.get()).booleanValue() || this.m_5833_())) {
            int toDrop = this.f_36078_ * 7;
            return Math.min(toDrop, 100);
        }
        return 0;
    }

    public boolean suffocatesAt(BlockPos blockPos) {
        AABB boundingBox = this.m_20191_();
        AABB aabb = new AABB((double)blockPos.m_123341_(), boundingBox.f_82289_, (double)blockPos.m_123343_(), (double)blockPos.m_123341_() + 1.0, boundingBox.f_82292_, (double)blockPos.m_123343_() + 1.0).m_82406_(1.0E-7);
        return this.m_9236_().m_186437_((Entity)this, aabb);
    }

    public boolean m_6109_() {
        return true;
    }

    protected void m_7840_(double dy, boolean onGround, BlockState _unused, BlockPos blockPos) {
        super.m_289599_((double)blockPos.m_123341_(), dy, (double)blockPos.m_123343_(), onGround);
    }

    @Nullable
    public Entity changeDimension(ServerLevel level, ITeleporter teleporter) {
        if (!ForgeHooks.onTravelToDimension((Entity)this, (ResourceKey)level.m_46472_())) {
            return null;
        }
        ServerLevel serverlevel = this.m_284548_();
        ResourceKey resourcekey = serverlevel.m_46472_();
        serverlevel.m_143261_((ServerPlayer)this, Entity.RemovalReason.CHANGED_DIMENSION);
        this.revive();
        PortalInfo portalInfo = teleporter.getPortalInfo((Entity)this, level, x$0 -> this.m_7937_((ServerLevel)x$0));
        if (portalInfo != null) {
            teleporter.placeEntity((Entity)this, serverlevel, level, this.m_146908_(), spawnPortal -> {
                if ((resourcekey != Level.f_46428_ || level.m_46472_() != Level.f_46429_) && spawnPortal.booleanValue() && level.m_46472_() == Level.f_46430_) {
                    ServerLevel.m_8617_((ServerLevel)level);
                }
                this.m_7678_(portalInfo.f_77676_.f_82479_, portalInfo.f_77676_.f_82480_, portalInfo.f_77676_.f_82481_, portalInfo.f_77678_, this.m_146909_());
                this.m_20256_(portalInfo.f_77677_);
                this.m_284127_(level);
                level.m_8817_((ServerPlayer)this);
                return this;
            });
            ForgeEventFactory.firePlayerChangedDimensionEvent((Player)this, (ResourceKey)resourcekey, (ResourceKey)level.m_46472_());
        }
        return this;
    }

    public void addWantedItemWithCount(Item item, int count) {
        this.wantedItemsWithCount.put(item, count);
    }

    public void removeWantedItemWithCount(Item item) {
        this.wantedItemsWithCount.remove(item);
    }

    public CompanionExplorationData getExplorationData() {
        return this.explorationData;
    }

    @Nullable
    public BlockPos getHomePosition() {
        return this.homePosition;
    }

    @Nullable
    public ResourceKey<Level> getHomeDimension() {
        return this.homeDimension;
    }

    public MtzController getController() {
        return this.controller;
    }

    public Set<Item> getWantedItems() {
        return this.wantedItems;
    }

    public CompanionPathfinder getPathFinder() {
        return this.pathFinder;
    }

    public BlockPlaceControl<ServerCompanionEntity> getBlockPlaceControl() {
        return this.blockPlaceControl;
    }

    public BlockBreakControl<ServerCompanionEntity> getBlockBreakControl() {
        return this.blockBreakControl;
    }

    public SprintControl<ServerCompanionEntity> getSprintControl() {
        return this.sprintControl;
    }

    public JumpControl getJumpControl() {
        return this.jumpControl;
    }

    public CrouchControl<ServerCompanionEntity> getCrouchControl() {
        return this.crouchControl;
    }

    public LookControl getLookControl() {
        return this.lookControl;
    }

    public BodyRotationControl getBodyRotationControl() {
        return this.bodyRotationControl;
    }

    @Mod.EventBusSubscriber(modid="mtz_companions", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public class AIChatEventHandler {
        protected void register() {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }

        protected void unregister() {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }

        @SubscribeEvent
        protected void onChatMessage(ServerChatEvent event) {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            if (event.getPlayer() == ServerCompanionEntity.this || this.mentionsCompanion(event.getRawText())) {
                // empty if block
            }
        }

        private boolean mentionsCompanion(String text) {
            if (ServerCompanionEntity.this.m_20194_().m_6846_().f_11196_.size() <= 2) {
                return true;
            }
            return text.contains("@" + String.valueOf(ServerCompanionEntity.this.m_5446_()));
        }
    }
}

